/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime.source;

import java.util.Optional;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

public final class SourceResult {
    private final Error invocationError;
    private final Error responseError;
    private final SourceCallbackContext sourceCallbackContext;

    public static SourceResult success(SourceCallbackContext sourceCallbackContext) {
        return new SourceResult(null, null, sourceCallbackContext);
    }

    public static SourceResult responseError(Error responseError, SourceCallbackContext sourceCallbackContext) {
        return new SourceResult(null, responseError, sourceCallbackContext);
    }

    public static SourceResult invocationError(Error invocationError, SourceCallbackContext sourceCallbackContext) {
        return new SourceResult(invocationError, null, sourceCallbackContext);
    }

    private SourceResult(Error invocationError, Error responseError, SourceCallbackContext sourceCallbackContext) {
        this.invocationError = invocationError;
        this.responseError = responseError;
        this.sourceCallbackContext = sourceCallbackContext;
    }

    public boolean isSuccess() {
        return this.invocationError == null && this.responseError == null;
    }

    public Optional<Error> getInvocationError() {
        return Optional.ofNullable(this.invocationError);
    }

    public Optional<Error> getResponseError() {
        return Optional.ofNullable(this.responseError);
    }

    public SourceCallbackContext getSourceCallbackContext() {
        return this.sourceCallbackContext;
    }
}

