/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;

public abstract class AbstractOAuthDancerBuilder<D>
implements OAuthDancerBuilder<D> {
    protected final LockFactory lockProvider;
    protected final Map<String, DefaultResourceOwnerOAuthContext> tokensStore;
    protected final HttpService httpService;
    protected final MuleExpressionLanguage expressionEvaluator;
    protected String clientId;
    protected String clientSecret;
    protected String tokenUrl;
    protected Supplier<HttpClient> httpClientFactory;
    protected Charset encoding = StandardCharsets.UTF_8;
    protected String responseAccessTokenExpr = "#[payload.access_token]";
    protected String responseRefreshTokenExpr = "#[payload.refresh_token]";
    protected String responseExpiresInExpr = "#[payload.expires_in]";
    protected String scopes = null;
    protected Map<String, String> customParametersExtractorsExprs;
    protected Function<String, String> resourceOwnerIdTransformer = resourceOwnerId -> resourceOwnerId;

    public AbstractOAuthDancerBuilder(LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpService httpService, MuleExpressionLanguage expressionEvaluator) {
        this.lockProvider = lockProvider;
        this.tokensStore = tokensStore;
        this.httpService = httpService;
        this.expressionEvaluator = expressionEvaluator;
    }

    public OAuthDancerBuilder clientCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this;
    }

    public OAuthDancerBuilder tokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        this.httpClientFactory = () -> {
            HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setName(String.format("oauthToken.requester[%s]", tokenUrl));
            return this.httpService.getClientFactory().create(clientConfigBuilder.build());
        };
        return this;
    }

    public OAuthDancerBuilder tokenUrl(final HttpClient httpClient, String tokenUrl) {
        this.httpClientFactory = () -> new HttpClient(){

            public void stop() {
            }

            public void start() {
            }

            public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) {
                return httpClient.sendAsync(request, responseTimeout, followRedirects, authentication);
            }

            public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
                return httpClient.send(request, responseTimeout, followRedirects, authentication);
            }
        };
        this.tokenUrl = tokenUrl;
        return this;
    }

    public OAuthDancerBuilder tokenUrl(String tokenUrl, TlsContextFactory tlsContextFactory) {
        this.tokenUrl = tokenUrl;
        this.httpClientFactory = () -> {
            HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setName(String.format("oauthToken.requester[%s]", tokenUrl));
            clientConfigBuilder.setTlsContextFactory(tlsContextFactory);
            return this.httpService.getClientFactory().create(clientConfigBuilder.build());
        };
        return this;
    }

    public OAuthDancerBuilder scopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuthDancerBuilder encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public OAuthDancerBuilder responseAccessTokenExpr(String responseAccessTokenExpr) {
        this.responseAccessTokenExpr = responseAccessTokenExpr;
        return this;
    }

    public OAuthDancerBuilder responseRefreshTokenExpr(String responseRefreshTokenExpr) {
        this.responseRefreshTokenExpr = responseRefreshTokenExpr;
        return this;
    }

    public OAuthDancerBuilder responseExpiresInExpr(String responseExpiresInExpr) {
        this.responseExpiresInExpr = responseExpiresInExpr;
        return this;
    }

    public OAuthDancerBuilder customParametersExtractorsExprs(Map<String, String> customParamsExtractorsExprs) {
        this.customParametersExtractorsExprs = customParamsExtractorsExprs;
        return this;
    }

    public OAuthDancerBuilder<D> resourceOwnerIdTransformer(Function<String, String> resourceOwnerIdTransformer) {
        this.resourceOwnerIdTransformer = resourceOwnerIdTransformer;
        return this;
    }
}

