/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;

public class ArtifactPluginDescriptorFactory
extends AbstractArtifactDescriptorFactory<MulePluginModel, ArtifactPluginDescriptor> {
    public ArtifactPluginDescriptorFactory() {
        this(new ServiceRegistryDescriptorLoaderRepository((ServiceRegistry)new SpiServiceRegistry()));
    }

    public ArtifactPluginDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository) {
        super(descriptorLoaderRepository);
    }

    public ArtifactPluginDescriptor create(File pluginJarFile) throws ArtifactDescriptorCreateException {
        try {
            Preconditions.checkArgument((pluginJarFile.isDirectory() || pluginJarFile.getName().endsWith(".jar") ? 1 : 0) != 0, (String)("provided file is not a plugin: " + pluginJarFile.getAbsolutePath()));
            String mulePluginJsonPathInsideJarFile = "META-INF/mule-artifact/mule-artifact.json";
            Optional jsonDescriptorContentOptional = JarUtils.loadFileContentFrom((File)pluginJarFile, (String)mulePluginJsonPathInsideJarFile);
            return jsonDescriptorContentOptional.map(jsonDescriptorContent -> (ArtifactPluginDescriptor)this.loadFromJsonDescriptor(pluginJarFile, this.loadModelFromJson(new String((byte[])jsonDescriptorContent)))).orElseThrow(() -> new ArtifactDescriptorCreateException(ArtifactPluginDescriptorFactory.pluginDescriptorNotFound(pluginJarFile, mulePluginJsonPathInsideJarFile)));
        }
        catch (ArtifactDescriptorCreateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
    }

    protected ArtifactType getArtifactType() {
        return ArtifactType.PLUGIN;
    }

    protected void doDescriptorConfig(MulePluginModel artifactModel, ArtifactPluginDescriptor descriptor, File artifactLocation) {
        artifactModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptor -> {
            LoaderDescriber loaderDescriber = new LoaderDescriber(extensionModelDescriptor.getId());
            loaderDescriber.addAttributes(extensionModelDescriptor.getAttributes());
            descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        });
    }

    protected ArtifactPluginDescriptor createArtifactDescriptor(File artifactLocation, String name) {
        return new ArtifactPluginDescriptor(name);
    }

    private static String pluginDescriptorNotFound(File pluginFile, String mulePluginJsonPathInsideJarFile) {
        return String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPathInsideJarFile, pluginFile);
    }

    protected AbstractMuleArtifactModelJsonSerializer<MulePluginModel> getMuleArtifactModelJsonSerializer() {
        return new MulePluginModelJsonSerializer();
    }
}

