/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.interceptor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.OperationType;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.MessageObserver;
import org.mule.runtime.extension.api.soap.message.DispatchingRequest;
import org.mule.runtime.extension.api.soap.message.DispatchingResponse;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;

public class MessageDispatcherInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final MessageObserver messageObserver;

    public MessageDispatcherInterceptor(MessageObserver messageObserver) {
        super("send-ending");
        this.messageObserver = messageObserver;
    }

    public void handleMessage(Message message) throws Fault {
        Exchange exchange = message.getExchange();
        Object encoding = exchange.get((Object)Message.ENCODING);
        message.put((Object)Message.ENCODING, encoding);
        message.getInterceptorChain().doIntercept(message);
        message.setAttachments(Collections.emptyList());
        MessageDispatcher dispatcher = (MessageDispatcher)exchange.get((Object)"mule.soap.dispatcher");
        DispatchingResponse response = dispatcher.dispatch(this.getDispatchingRequest(message));
        exchange.put((Object)StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        if (OperationType.ONE_WAY.equals(exchange.get((Object)"mule.soap.operation.type"))) {
            exchange.put((Object)"exchange.finished", (Object)true);
        } else {
            this.handleRequestResponse(exchange, encoding, response);
        }
    }

    private void handleRequestResponse(Exchange exchange, Object encoding, DispatchingResponse response) {
        MessageImpl inMessage = new MessageImpl();
        inMessage.put((Object)Message.ENCODING, encoding);
        inMessage.put((Object)"Content-Type", (Object)response.getContentType());
        inMessage.setContent(InputStream.class, (Object)response.getContent());
        inMessage.setExchange(exchange);
        this.messageObserver.onMessage((Message)inMessage);
    }

    private DispatchingRequest getDispatchingRequest(Message message) {
        Exchange exchange = message.getExchange();
        String action = (String)exchange.get((Object)"mule.soap.action");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("SOAPAction", action);
        headers.put("Content-Type", (String)message.get((Object)"Content-Type"));
        headers.putAll((Map)exchange.get((Object)"mule.soap.transport.headers"));
        ByteArrayInputStream content = new ByteArrayInputStream(((OutputStream)message.getContent(OutputStream.class)).toString().getBytes());
        return new DispatchingRequest((InputStream)content, (String)exchange.get((Object)"mule.soap.address"), headers);
    }
}

