/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.introspection;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.wsdl11.CatalogWSDLLocator;
import org.mule.runtime.soap.api.transport.TransportResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

final class WsdlLocator
implements WSDLLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsdlLocator.class);
    private final WSDLLocator delegateLocator;
    private final TransportResourceLocator resourceLocator;
    private final List<InputStream> streams = new ArrayList<InputStream>();
    private final String wsdlLocation;
    private String latestImportUri;

    WsdlLocator(String wsdlLocation, TransportResourceLocator resourceLocator) {
        this.wsdlLocation = wsdlLocation;
        this.delegateLocator = new CatalogWSDLLocator(wsdlLocation);
        this.resourceLocator = resourceLocator;
    }

    public InputSource getBaseInputSource() {
        return this.resourceLocator.handles(this.wsdlLocation) ? this.getInputSource(this.wsdlLocation) : this.delegateLocator.getBaseInputSource();
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        try {
            if (this.resourceLocator.handles(importLocation)) {
                this.latestImportUri = importLocation;
                return this.getInputSource(this.latestImportUri);
            }
            InputSource importInputSource = this.delegateLocator.getImportInputSource(parentLocation, importLocation);
            this.latestImportUri = this.delegateLocator.getLatestImportURI();
            return importInputSource;
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving the following WSDL resource: " + this.latestImportUri, e);
        }
    }

    public String getBaseURI() {
        return this.wsdlLocation;
    }

    public String getLatestImportURI() {
        return this.latestImportUri;
    }

    public void close() {
        this.streams.forEach(stream -> {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing resource stream during WSDL retrieval", (Throwable)e);
            }
        });
    }

    private InputSource getInputSource(String url) {
        try {
            InputStream resultStream = this.resourceLocator.getResource(url);
            this.streams.add(resultStream);
            return new InputSource(resultStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error fetching the resource [" + url + "]: " + e.getMessage(), e);
        }
    }
}

