/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.introspection.OperationDefinition;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;

abstract class AttachmentsMetadataResolver
extends NodeMetadataResolver {
    AttachmentsMetadataResolver(ServiceDefinition definition, TypeLoader loader, Function<OperationDefinition, Optional<Part>> partRetriever) {
        super(definition, loader, partRetriever);
    }

    @Override
    public MetadataType getMetadata(String operation) throws MetadataResolvingException {
        Part bodyPart = this.getBodyPart(this.definition.getOperation(operation));
        MetadataType bodyType = this.buildPartMetadataType(bodyPart);
        List<ObjectFieldType> attachments = SoapServiceMetadataTypeUtils.getAttachmentFields(bodyType);
        if (attachments.isEmpty()) {
            return this.nullType;
        }
        ObjectTypeBuilder type = this.typeBuilder.objectType();
        attachments.forEach(attachment -> type.addField().key(MetadataTypeUtils.getLocalPart((ObjectFieldType)attachment)).value(attachment.getValue()));
        return type.build();
    }
}

