/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.Set;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.metadata.AttachmentsMetadataResolver;
import org.mule.service.soap.metadata.BodyMetadataResolver;
import org.mule.service.soap.metadata.HeadersMetadataResolver;
import org.mule.service.soap.metadata.ImmutableSoapOperationMetadata;
import org.mule.service.soap.metadata.InputAttachmentsMetadataResolver;
import org.mule.service.soap.metadata.InputBodyMetadataResolver;
import org.mule.service.soap.metadata.InputHeadersMetadataResolver;
import org.mule.service.soap.metadata.OutputAttachmentsMetadataResolver;
import org.mule.service.soap.metadata.OutputBodyMetadataResolver;
import org.mule.service.soap.metadata.OutputHeadersMetadataResolver;
import org.mule.service.soap.metadata.ServiceOperationsResolver;

public class DefaultSoapMetadataResolver
implements SoapMetadataResolver {
    private final HeadersMetadataResolver inputHeadersResolver;
    private final HeadersMetadataResolver outputHeadersResolver;
    private final BodyMetadataResolver inputBodyResolver;
    private final BodyMetadataResolver outputBodyResolver;
    private final AttachmentsMetadataResolver inputAttachmentsResolver;
    private final AttachmentsMetadataResolver outputAttachmentsResolver;
    private final ServiceOperationsResolver keysResolver;

    public DefaultSoapMetadataResolver(ServiceDefinition definition, TypeLoader loader) {
        this.inputHeadersResolver = new InputHeadersMetadataResolver(definition, loader);
        this.outputHeadersResolver = new OutputHeadersMetadataResolver(definition, loader);
        this.outputAttachmentsResolver = new OutputAttachmentsMetadataResolver(definition, loader);
        this.inputAttachmentsResolver = new InputAttachmentsMetadataResolver(definition, loader);
        this.inputBodyResolver = new InputBodyMetadataResolver(definition, loader);
        this.outputBodyResolver = new OutputBodyMetadataResolver(definition, loader);
        this.keysResolver = new ServiceOperationsResolver(definition);
    }

    public SoapOperationMetadata getInputMetadata(String operation) throws MetadataResolvingException {
        return new ImmutableSoapOperationMetadata(this.inputBodyResolver.getMetadata(operation), this.inputHeadersResolver.getMetadata(operation), this.inputAttachmentsResolver.getMetadata(operation));
    }

    public SoapOperationMetadata getOutputMetadata(String operation) throws MetadataResolvingException {
        return new ImmutableSoapOperationMetadata(this.outputBodyResolver.getMetadata(operation), this.outputHeadersResolver.getMetadata(operation), this.outputAttachmentsResolver.getMetadata(operation));
    }

    public Set<String> getAvailableOperations() {
        return this.keysResolver.getAvailableOperations();
    }
}

