/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.introspection.OperationDefinition;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.introspection.SoapHeaderAdapter;
import org.mule.service.soap.metadata.NodeMetadataResolver;

abstract class HeadersMetadataResolver
extends NodeMetadataResolver {
    private final Function<OperationDefinition, Message> messageRetriever;
    private final Function<OperationDefinition, List<SoapHeaderAdapter>> headersRetriever;

    HeadersMetadataResolver(ServiceDefinition definition, TypeLoader loader, Function<OperationDefinition, Message> messageRetriever, Function<OperationDefinition, List<SoapHeaderAdapter>> headersRetriever) {
        super(definition, loader, o -> Optional.empty());
        this.messageRetriever = messageRetriever;
        this.headersRetriever = headersRetriever;
    }

    @Override
    public MetadataType getMetadata(String operationName) throws MetadataResolvingException {
        OperationDefinition operation = this.definition.getOperation(operationName);
        List<SoapHeaderAdapter> headers = this.headersRetriever.apply(operation);
        if (!headers.isEmpty()) {
            return this.buildHeaderType(headers, this.messageRetriever.apply(operation));
        }
        return this.nullType;
    }

    private MetadataType buildHeaderType(List<SoapHeaderAdapter> headers, Message message) throws MetadataResolvingException {
        ObjectTypeBuilder objectType = this.typeBuilder.objectType();
        for (SoapHeaderAdapter header : headers) {
            ObjectFieldTypeBuilder field = objectType.addField();
            String headerPart = header.getPart();
            Part part = message.getPart(headerPart);
            if (part != null) {
                field.key(headerPart).value(this.buildPartMetadataType(part));
                continue;
            }
            Message headerMessage = this.definition.getMessage(header.getMessage());
            field.key(headerPart).value(this.buildPartMetadataType(headerMessage.getPart(headerPart)));
        }
        return objectType.build();
    }
}

