/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.deserializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AttributeFieldTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.deserializer.AbstractTypeDeserializer;
import org.mule.metadata.persistence.deserializer.SerializerUtils;

final class ObjectTypeDeserializer
extends AbstractTypeDeserializer {
    ObjectTypeDeserializer() {
        super(BaseTypeBuilder::objectType);
    }

    @Override
    public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader) {
        ObjectTypeBuilder objectTypeBuilder = (ObjectTypeBuilder)this.supplier.get(baseBuilder);
        if (typeObject.has("ordered")) {
            objectTypeBuilder.ordered(typeObject.get("ordered").getAsBoolean());
        }
        if (typeObject.has("open")) {
            objectTypeBuilder.openWith(typeLoader.buildType(typeObject.get("open"), objectTypeBuilder.openWith()));
        }
        JsonElement fields = typeObject.get("fields");
        this.parseAnnotations(typeObject, (WithAnnotation)objectTypeBuilder);
        for (JsonElement jsonElement : fields.getAsJsonArray()) {
            ObjectFieldTypeBuilder fieldBuilder;
            JsonObject field = jsonElement.getAsJsonObject();
            JsonObject key = field.get("key").getAsJsonObject();
            String keyName = key.get("name").getAsString();
            if (this.isPattern((JsonElement)key)) {
                fieldBuilder = objectTypeBuilder.addField().key(Pattern.compile(keyName));
            } else {
                fieldBuilder = objectTypeBuilder.addField();
                ObjectKeyBuilder keyBuilder = fieldBuilder.key(this.parseKey(keyName));
                if (key.has("attributes")) {
                    this.parseAttributes(key, keyBuilder, typeLoader, SerializerUtils.VOLATILE_FORMAT);
                }
            }
            if (key.has("required")) {
                fieldBuilder.required(key.get("required").getAsBoolean());
            }
            if (key.has("repeated")) {
                fieldBuilder.repeated(key.get("repeated").getAsBoolean());
            }
            SerializerUtils.getAnnotations(key).forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).withKeyAnnotation(arg_0));
            SerializerUtils.getAnnotations(field).forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).with(arg_0));
            JsonElement valueElement = field.get("model");
            if (valueElement.isJsonObject()) {
                JsonObject valueObject = valueElement.getAsJsonObject();
                fieldBuilder.value(typeLoader.buildType((JsonElement)valueObject, new BaseTypeBuilder(SerializerUtils.VOLATILE_FORMAT)));
                continue;
            }
            fieldBuilder.value(typeLoader.buildType(valueElement, fieldBuilder.value()));
        }
        return objectTypeBuilder;
    }

    private void parseAttributes(JsonObject value, ObjectKeyBuilder objectKeyBuilder, JsonMetadataTypeLoader typeLoader, MetadataFormat format) {
        for (JsonElement attributeJsonElement : value.get("attributes").getAsJsonArray()) {
            AttributeFieldTypeBuilder attributeFieldTypeBuilder = objectKeyBuilder.addAttribute();
            JsonObject attribute = attributeJsonElement.getAsJsonObject();
            JsonObject attributeKey = attribute.get("key").getAsJsonObject();
            String attributeKeyName = attributeKey.get("name").getAsString();
            if (this.isPattern((JsonElement)attributeKey)) {
                attributeFieldTypeBuilder.pattern(Pattern.compile(attributeKeyName));
            } else {
                attributeFieldTypeBuilder.name(this.parseKey(attributeKeyName));
            }
            if (attributeKey.has("required")) {
                attributeFieldTypeBuilder.required(attributeKey.get("required").getAsBoolean());
            }
            JsonObject attributeModel = attribute.get("model").getAsJsonObject();
            attributeFieldTypeBuilder.value(typeLoader.buildType((JsonElement)attributeModel, new BaseTypeBuilder(format)));
        }
    }

    private QName parseKey(String key) {
        Pattern compile = Pattern.compile("(?:\\{([\\d\\w\\D\\W]*)\\})?([\\d\\w\\D\\W]*)");
        Matcher matcher = compile.matcher(key);
        if (matcher.find()) {
            if (matcher.groupCount() == 1) {
                return new QName(key);
            }
            if (matcher.groupCount() == 2) {
                return new QName(matcher.group(1), matcher.group(2));
            }
        }
        return new QName(key);
    }

    private boolean isPattern(JsonElement value) {
        if (value.isJsonObject()) {
            for (TypeAnnotation typeAnnotation : SerializerUtils.getAnnotations(value.getAsJsonObject())) {
                if (!typeAnnotation.getName().equals("pattern")) continue;
                return true;
            }
        }
        return false;
    }
}

