/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.deserializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.persistence.TypeAnnotationSerializer;
import org.mule.metadata.persistence.TypeAnnotationSerializerFactory;

final class SerializerUtils {
    private static final TypeAnnotationSerializer TYPE_ANNOTATION_SERIALIZER = TypeAnnotationSerializerFactory.getInstance().getTypeAnnotationSerializer();
    static MetadataFormat VOLATILE_FORMAT = new MetadataFormat("", "id", new String[0]);

    SerializerUtils() {
    }

    static List<TypeAnnotation> getAnnotations(JsonObject type) {
        if (type.has("annotations")) {
            JsonObject annotations = type.get("annotations").getAsJsonObject();
            ArrayList<TypeAnnotation> annotationList = new ArrayList<TypeAnnotation>();
            for (Map.Entry annotation : annotations.entrySet()) {
                Optional<TypeAnnotation> typeAnnotation = SerializerUtils.parseTypeAnnotation(annotation);
                if (!typeAnnotation.isPresent()) continue;
                annotationList.add(typeAnnotation.get());
            }
            return annotationList;
        }
        return Collections.emptyList();
    }

    private static Optional<TypeAnnotation> parseTypeAnnotation(Map.Entry<String, JsonElement> annotation) {
        return TYPE_ANNOTATION_SERIALIZER.deserialize(annotation.getKey(), annotation.getValue().toString());
    }
}

