/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class ModelUtils {
    private static final Set<Class<?>> WRAPPERS_PLUS_STRING = new HashSet();

    public static boolean isPrimitiveOrWrapperOrString(Class<?> type) {
        return type.isPrimitive() || WRAPPERS_PLUS_STRING.contains(type);
    }

    public static boolean isObject(Class<?> type) {
        return Object.class.equals(type);
    }

    public static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ModelUtils.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            return ModelUtils.toClass(((WildcardType)type).getUpperBounds()[0]);
        }
        return Object.class;
    }

    static {
        WRAPPERS_PLUS_STRING.add(Boolean.class);
        WRAPPERS_PLUS_STRING.add(Character.class);
        WRAPPERS_PLUS_STRING.add(Byte.class);
        WRAPPERS_PLUS_STRING.add(Short.class);
        WRAPPERS_PLUS_STRING.add(Integer.class);
        WRAPPERS_PLUS_STRING.add(Long.class);
        WRAPPERS_PLUS_STRING.add(Float.class);
        WRAPPERS_PLUS_STRING.add(Double.class);
        WRAPPERS_PLUS_STRING.add(BigInteger.class);
        WRAPPERS_PLUS_STRING.add(BigDecimal.class);
        WRAPPERS_PLUS_STRING.add(String.class);
    }
}

