/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidatorHelper;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;

public class ValidationState
implements ValidationContext {
    private boolean fExtraChecking = true;
    private boolean fFacetChecking = true;
    private boolean fNormalize = true;
    private boolean fNamespaces = true;
    private EntityState fEntityState = null;
    private NamespaceContext fNamespaceContext = null;
    private SymbolTable fSymbolTable = null;
    private Locale fLocale = null;
    private final HashMap fIdTable = new HashMap();
    private final LinkedHashMap fIdRefTable = new LinkedHashMap();
    private static final Object fNullValue = new Object();
    private TypeValidatorHelper fTypeValidatorHelper = null;
    private short fXMLVersion = 1;

    public void setExtraChecking(boolean newValue) {
        this.fExtraChecking = newValue;
    }

    public void setFacetChecking(boolean newValue) {
        this.fFacetChecking = newValue;
    }

    public void setNormalizationRequired(boolean newValue) {
        this.fNormalize = newValue;
    }

    public void setUsingNamespaces(boolean newValue) {
        this.fNamespaces = newValue;
    }

    public void setEntityState(EntityState state) {
        this.fEntityState = state;
    }

    public void setNamespaceSupport(NamespaceContext namespace) {
        this.fNamespaceContext = namespace;
    }

    public void setSymbolTable(SymbolTable sTable) {
        this.fSymbolTable = sTable;
    }

    public Iterator checkIDRefID() {
        LinkedHashSet<String> missingIDs = null;
        for (String key : this.fIdRefTable.keySet()) {
            if (this.containsID(key)) continue;
            if (missingIDs == null) {
                missingIDs = new LinkedHashSet<String>();
            }
            missingIDs.add(key);
        }
        return missingIDs != null ? missingIDs.iterator() : null;
    }

    protected boolean containsID(String name) {
        return this.fIdTable.containsKey(name);
    }

    public void reset() {
        this.fExtraChecking = true;
        this.fFacetChecking = true;
        this.fNamespaces = true;
        this.fIdTable.clear();
        this.fIdRefTable.clear();
        this.fEntityState = null;
        this.fNamespaceContext = null;
        this.fSymbolTable = null;
    }

    public void resetIDTables() {
        this.fIdTable.clear();
        this.fIdRefTable.clear();
    }

    @Override
    public boolean needExtraChecking() {
        return this.fExtraChecking;
    }

    @Override
    public boolean needFacetChecking() {
        return this.fFacetChecking;
    }

    @Override
    public boolean needToNormalize() {
        return this.fNormalize;
    }

    @Override
    public boolean useNamespaces() {
        return this.fNamespaces;
    }

    @Override
    public boolean isEntityDeclared(String name) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityDeclared(this.getSymbol(name));
        }
        return false;
    }

    @Override
    public boolean isEntityUnparsed(String name) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityUnparsed(this.getSymbol(name));
        }
        return false;
    }

    @Override
    public boolean isIdDeclared(String name) {
        return this.fIdTable.containsKey(name);
    }

    @Override
    public void addId(String name) {
        this.fIdTable.put(name, fNullValue);
    }

    @Override
    public void addIdRef(String name) {
        this.fIdRefTable.put(name, fNullValue);
    }

    @Override
    public String getSymbol(String symbol) {
        if (this.fSymbolTable != null) {
            return this.fSymbolTable.addSymbol(symbol);
        }
        return symbol.intern();
    }

    @Override
    public String getURI(String prefix) {
        if (this.fNamespaceContext != null) {
            return this.fNamespaceContext.getURI(prefix);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    public void setTypeValidatorHelper(TypeValidatorHelper typeValidatorHelper) {
        this.fTypeValidatorHelper = typeValidatorHelper;
    }

    @Override
    public TypeValidatorHelper getTypeValidatorHelper() {
        return this.fTypeValidatorHelper;
    }

    public void setDatatypeXMLVersion(short xmlVersion) {
        this.fXMLVersion = xmlVersion;
    }

    @Override
    public short getDatatypeXMLVersion() {
        return this.fXMLVersion;
    }
}

