/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.nodes.RamlTypedFragmentNode;
import org.raml.v2.internal.utils.ResourcePathUtils;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.IncludeErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNodeImpl;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.nodes.snakeyaml.NodeParser;
import org.raml.yagi.framework.nodes.snakeyaml.SYIncludeNode;
import org.raml.yagi.framework.phase.Transformer;

public class IncludeResolver
implements Transformer,
ResourceUriCallback {
    private final ResourceLoader resourceLoader;
    private String includedResourceUri;

    public IncludeResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean matches(Node node) {
        return node instanceof SYIncludeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node transform(Node node) {
        Object result;
        InputStream inputStream;
        String resourcePath;
        block9: {
            IncludeErrorNode includeErrorNode;
            SYIncludeNode includeNode = (SYIncludeNode)node;
            resourcePath = ResourcePathUtils.toAbsoluteLocation(node.getStartPosition().getPath(), includeNode.getIncludePath());
            inputStream = null;
            try {
                inputStream = this.resourceLoader instanceof ResourceLoaderExtended ? ((ResourceLoaderExtended)this.resourceLoader).fetchResource(resourcePath, (ResourceUriCallback)this) : this.resourceLoader.fetchResource(resourcePath);
                if (inputStream != null) break block9;
                includeErrorNode = new IncludeErrorNode("Include cannot be resolved: " + resourcePath);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return includeErrorNode;
        }
        String includeContent = StreamUtils.toString(inputStream);
        if (resourcePath.endsWith(".raml") || resourcePath.endsWith(".yaml") || resourcePath.endsWith(".yml")) {
            try {
                RamlHeader ramlHeader = RamlHeader.parse(includeContent);
                RamlFragment fragment = ramlHeader.getFragment();
                result = NodeParser.parse((ResourceLoader)this.resourceLoader, (String)resourcePath, (String)includeContent);
                if (result != null && this.isTypedFragment((Node)result, fragment)) {
                    RamlTypedFragmentNode newNode = new RamlTypedFragmentNode(fragment);
                    result.replaceWith((Node)newNode);
                    result = newNode;
                }
            }
            catch (RamlHeader.InvalidHeaderException e) {
                result = NodeParser.parse((ResourceLoader)this.resourceLoader, (String)resourcePath, (String)includeContent);
            }
        } else {
            result = new StringNodeImpl(includeContent);
            this.setTempPositionWithResourceUri((Node)result);
        }
        if (result == null) {
            result = new NullNodeImpl();
        }
        Node node2 = result;
        IOUtils.closeQuietly((InputStream)inputStream);
        return node2;
    }

    private void setTempPositionWithResourceUri(Node result) {
        Position startPosition = result.getStartPosition();
        Position endPosition = result.getEndPosition();
        startPosition.setIncludedResourceUri(this.includedResourceUri);
        endPosition.setIncludedResourceUri(this.includedResourceUri);
        ((AbstractRamlNode)result).setStartPosition(startPosition);
        ((AbstractRamlNode)result).setEndPosition(endPosition);
    }

    private boolean isTypedFragment(Node result, RamlFragment fragment) {
        return fragment != null && fragment != RamlFragment.Library && result instanceof ObjectNode;
    }

    public void onResourceFound(URI resourceURI) {
        this.includedResourceUri = resourceURI.toString();
    }
}

