/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.v2.internal.impl.commons.nodes.CustomFacetDefinitionNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;

public class ResolvedCustomFacets {
    private Map<String, CustomFacetDefinitionNode> customFacets;
    private List<String> nativeFacets;

    public ResolvedCustomFacets(String ... nativeFacets) {
        this(Arrays.asList(nativeFacets), new HashMap<String, CustomFacetDefinitionNode>());
    }

    public ResolvedCustomFacets(List<String> nativeFacets, Map<String, CustomFacetDefinitionNode> facets) {
        this.customFacets = facets;
        this.nativeFacets = nativeFacets;
    }

    public TypeDeclarationNode validate(TypeDeclarationNode from) {
        List<CustomFacetDefinitionNode> customFacets = from.getCustomFacets();
        for (CustomFacetDefinitionNode customFacet : customFacets) {
            if (this.nativeFacets.contains(customFacet.getFacetName())) {
                customFacet.replaceWith((Node)RamlErrorNodeFactory.createCanNotOverrideNativeFacet(customFacet.getFacetName()));
                continue;
            }
            if (!this.customFacets.containsKey(customFacet.getFacetName())) continue;
            TypeDeclarationNode parentTypeDeclaration = (TypeDeclarationNode)customFacet.findAncestorWith(TypeDeclarationNode.class);
            String typeName = parentTypeDeclaration != null ? parentTypeDeclaration.getTypeName() : "";
            customFacet.replaceWith((Node)RamlErrorNodeFactory.createCanNotOverrideCustomFacet(customFacet.getFacetName(), typeName));
        }
        return from;
    }

    public ResolvedCustomFacets mergeWith(ResolvedCustomFacets customFacets) {
        ResolvedCustomFacets copy = this.copy();
        copy.customFacets.putAll(customFacets.customFacets);
        return copy;
    }

    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (CustomFacetDefinitionNode facetDefinitionNode : this.customFacets.values()) {
            rules.add((Rule)facetDefinitionNode.getFacetRule());
        }
        return rules;
    }

    public ResolvedCustomFacets copy() {
        return new ResolvedCustomFacets(this.nativeFacets, new HashMap<String, CustomFacetDefinitionNode>(this.customFacets));
    }

    public ResolvedCustomFacets overwriteFacets(TypeDeclarationNode from) {
        HashMap<String, CustomFacetDefinitionNode> facets = new HashMap<String, CustomFacetDefinitionNode>(this.customFacets);
        List<CustomFacetDefinitionNode> customFacets = from.getCustomFacets();
        for (CustomFacetDefinitionNode customFacet : customFacets) {
            facets.put(customFacet.getFacetName(), customFacet);
        }
        return new ResolvedCustomFacets(this.nativeFacets, facets);
    }
}

