/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberRange;
import org.apache.commons.lang.math.Range;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.JsonSchemaValidationRule;
import org.raml.v2.internal.impl.commons.rule.XmlSchemaValidationRule;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.rules.DiscriminatorBasedRule;
import org.raml.v2.internal.impl.v10.rules.FormatValueRule;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.ArrayResolvedType;
import org.raml.v2.internal.impl.v10.type.BooleanResolvedType;
import org.raml.v2.internal.impl.v10.type.DateOnlyResolvedType;
import org.raml.v2.internal.impl.v10.type.DateTimeOnlyResolvedType;
import org.raml.v2.internal.impl.v10.type.DateTimeResolvedType;
import org.raml.v2.internal.impl.v10.type.FileResolvedType;
import org.raml.v2.internal.impl.v10.type.IntegerResolvedType;
import org.raml.v2.internal.impl.v10.type.NullResolvedType;
import org.raml.v2.internal.impl.v10.type.NumberResolvedType;
import org.raml.v2.internal.impl.v10.type.ObjectResolvedType;
import org.raml.v2.internal.impl.v10.type.PropertyFacets;
import org.raml.v2.internal.impl.v10.type.StringResolvedType;
import org.raml.v2.internal.impl.v10.type.TimeOnlyResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.v2.internal.utils.BasicRuleFactory;
import org.raml.v2.internal.utils.ValueUtils;
import org.raml.yagi.framework.grammar.rule.AllOfRule;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.AnyValueRule;
import org.raml.yagi.framework.grammar.rule.ArrayRule;
import org.raml.yagi.framework.grammar.rule.BooleanTypeRule;
import org.raml.yagi.framework.grammar.rule.DateValueRule;
import org.raml.yagi.framework.grammar.rule.DivisorValueRule;
import org.raml.yagi.framework.grammar.rule.IntegerTypeRule;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.MaxItemsRule;
import org.raml.yagi.framework.grammar.rule.MaxLengthRule;
import org.raml.yagi.framework.grammar.rule.MaxPropertiesRule;
import org.raml.yagi.framework.grammar.rule.MaximumValueRule;
import org.raml.yagi.framework.grammar.rule.MinItemsRule;
import org.raml.yagi.framework.grammar.rule.MinLengthRule;
import org.raml.yagi.framework.grammar.rule.MinPropertiesRule;
import org.raml.yagi.framework.grammar.rule.MinimumValueRule;
import org.raml.yagi.framework.grammar.rule.NullValueRule;
import org.raml.yagi.framework.grammar.rule.NumberTypeRule;
import org.raml.yagi.framework.grammar.rule.NumberValueRule;
import org.raml.yagi.framework.grammar.rule.ObjectRule;
import org.raml.yagi.framework.grammar.rule.RangeValueRule;
import org.raml.yagi.framework.grammar.rule.RegexValueRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.StringTypeRule;
import org.raml.yagi.framework.util.DateType;

public class TypeToRuleVisitor
implements TypeVisitor<Rule> {
    private ResourceLoader resourceLoader;
    private boolean strictMode = false;
    private Map<ResolvedType, Rule> definitionRuleMap = new IdentityHashMap<ResolvedType, Rule>();
    private boolean resolvingDiscriminator = false;

    public TypeToRuleVisitor(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Rule generateRule(ResolvedType items) {
        if (this.definitionRuleMap.containsKey(items)) {
            return this.definitionRuleMap.get(items);
        }
        return items.visit(this);
    }

    @Override
    public Rule visitString(StringResolvedType stringTypeNode) {
        Integer maxLength;
        AllOfRule typeRule = new AllOfRule(new Rule[]{new StringTypeRule()});
        this.registerRule(stringTypeNode, (Rule)typeRule);
        if (StringUtils.isNotEmpty((String)stringTypeNode.getPattern())) {
            typeRule.and((Rule)new RegexValueRule(Pattern.compile(stringTypeNode.getPattern())));
        }
        if (stringTypeNode.getEnums() != null && !stringTypeNode.getEnums().isEmpty()) {
            typeRule.and((Rule)new AnyOfRule(new ArrayList<Rule>(this.getStringRules(stringTypeNode.getEnums()))));
        }
        if (stringTypeNode.getMaxLength() != null) {
            maxLength = stringTypeNode.getMaxLength();
            typeRule.and((Rule)new MaxLengthRule(maxLength.intValue()));
        }
        if (stringTypeNode.getMinLength() != null) {
            maxLength = stringTypeNode.getMinLength();
            typeRule.and((Rule)new MinLengthRule(maxLength.intValue()));
        }
        return typeRule;
    }

    private List<Rule> getStringRules(List<String> enumValues) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (String value : enumValues) {
            rules.add((Rule)BasicRuleFactory.stringValue(value));
        }
        return rules;
    }

    public void resolveDiscrimintor() {
        this.resolvingDiscriminator = true;
    }

    @Override
    public Rule visitObject(ObjectResolvedType objectTypeDefinition) {
        if (!this.resolvingDiscriminator && StringUtils.isNotEmpty((String)objectTypeDefinition.getDiscriminator())) {
            this.resolvingDiscriminator = false;
            TypeExpressionNode typeDeclarationNode = objectTypeDefinition.getTypeExpressionNode();
            return new DiscriminatorBasedRule(this, typeDeclarationNode.getRootNode(), objectTypeDefinition.getDiscriminator());
        }
        ObjectRule objectRule = new ObjectRule(this.strictMode);
        this.registerRule(objectTypeDefinition, (Rule)objectRule);
        boolean additionalProperties = ValueUtils.asBoolean(objectTypeDefinition.getAdditionalProperties(), true);
        objectRule.additionalProperties(additionalProperties);
        Map<String, PropertyFacets> properties = objectTypeDefinition.getProperties();
        for (Map.Entry<String, PropertyFacets> property : properties.entrySet()) {
            KeyValueRule keyValue;
            PropertyFacets propertyValue = property.getValue();
            Rule value = this.generateRule(propertyValue.getValueType());
            if (propertyValue.isPatternProperty()) {
                if (!additionalProperties) continue;
                keyValue = new KeyValueRule((Rule)BasicRuleFactory.regexValue(propertyValue.getPatternRegex()).fullMatch(false), value);
                objectRule.additionalProperties(false);
                objectRule.with(keyValue);
                continue;
            }
            keyValue = BasicRuleFactory.property(property.getKey(), value);
            Boolean required = propertyValue.isRequired();
            if (required.booleanValue()) {
                keyValue.required();
            }
            objectRule.with(keyValue);
        }
        AllOfRule allOfRule = new AllOfRule(new Rule[]{objectRule});
        if (objectTypeDefinition.getMaxProperties() != null) {
            allOfRule.and((Rule)new MaxPropertiesRule(objectTypeDefinition.getMaxProperties().intValue()));
        }
        if (objectTypeDefinition.getMinProperties() != null) {
            allOfRule.and((Rule)new MinPropertiesRule(objectTypeDefinition.getMinProperties().intValue()));
        }
        return allOfRule;
    }

    protected void registerRule(ResolvedType objectResolvedType, Rule objectRule) {
        this.definitionRuleMap.put(objectResolvedType, objectRule);
    }

    @Override
    public Rule visitBoolean(BooleanResolvedType booleanTypeDefinition) {
        return new BooleanTypeRule();
    }

    @Override
    public Rule visitInteger(IntegerResolvedType integerTypeDefinition) {
        return this.visitNumber(integerTypeDefinition, (Rule)new IntegerTypeRule());
    }

    @Override
    public Rule visitNumber(NumberResolvedType numberTypeDefinition) {
        return this.visitNumber(numberTypeDefinition, (Rule)new NumberTypeRule());
    }

    private Rule visitNumber(NumberResolvedType numericTypeNode, Rule numericTypeRule) {
        List<Number> enums;
        AllOfRule typeRule = new AllOfRule(new Rule[]{numericTypeRule});
        this.registerRule(numericTypeNode, (Rule)typeRule);
        if (numericTypeNode.getMinimum() != null && numericTypeNode.getMaximum() != null) {
            typeRule.and((Rule)new RangeValueRule((Range)new NumberRange(numericTypeNode.getMinimum(), numericTypeNode.getMaximum())));
        } else if (numericTypeNode.getMinimum() != null) {
            typeRule.and((Rule)new MinimumValueRule(numericTypeNode.getMinimum()));
        } else if (numericTypeNode.getMaximum() != null) {
            typeRule.and((Rule)new MaximumValueRule(numericTypeNode.getMaximum()));
        }
        if (numericTypeNode.getMultiple() != null) {
            typeRule.and((Rule)new DivisorValueRule(numericTypeNode.getMultiple()));
        }
        if (numericTypeNode.getFormat() != null) {
            typeRule.and((Rule)new FormatValueRule(numericTypeNode.getFormat()));
        }
        if ((enums = numericTypeNode.getEnums()) != null && !enums.isEmpty()) {
            ArrayList<NumberValueRule> options = new ArrayList<NumberValueRule>();
            for (Number anEnum : enums) {
                options.add(new NumberValueRule(anEnum));
            }
            typeRule.and((Rule)new AnyOfRule(options));
        }
        return typeRule;
    }

    @Override
    public Rule visitDateTimeOnly(DateTimeOnlyResolvedType dateTimeOnlyTypeDefinition) {
        return new DateValueRule(DateType.datetime_only, null);
    }

    @Override
    public Rule visitDate(DateOnlyResolvedType dateOnlyTypeDefinition) {
        return new DateValueRule(DateType.date_only, null);
    }

    @Override
    public Rule visitDateTime(DateTimeResolvedType dateTimeTypeDefinition) {
        return new DateValueRule(DateType.datetime, dateTimeTypeDefinition.getFormat());
    }

    @Override
    public Rule visitTimeOnly(TimeOnlyResolvedType timeOnlyTypeDefinition) {
        return new DateValueRule(DateType.time_only, null);
    }

    @Override
    public Rule visitJson(JsonSchemaExternalType jsonTypeDefinition) {
        return new JsonSchemaValidationRule(jsonTypeDefinition);
    }

    @Override
    public Rule visitXml(XmlSchemaExternalType xmlTypeDefinition) {
        return new XmlSchemaValidationRule(xmlTypeDefinition, this.resourceLoader);
    }

    @Override
    public Rule visitAny(AnyResolvedType anyResolvedType) {
        return new AnyValueRule();
    }

    @Override
    public Rule visitFile(FileResolvedType fileTypeDefinition) {
        return new AnyValueRule();
    }

    @Override
    public Rule visitNull(NullResolvedType nullTypeDefinition) {
        return new NullValueRule();
    }

    @Override
    public Rule visitArray(ArrayResolvedType arrayTypeDefinition) {
        ResolvedType items = arrayTypeDefinition.getItems();
        AllOfRule rule = new AllOfRule(new Rule[]{new ArrayRule(this.generateRule(items), this.strictMode)});
        this.registerRule(arrayTypeDefinition, (Rule)rule);
        if (arrayTypeDefinition.getMaxItems() != null) {
            rule.and((Rule)new MaxItemsRule(arrayTypeDefinition.getMaxItems().intValue()));
        }
        if (arrayTypeDefinition.getMinItems() != null) {
            rule.and((Rule)new MinItemsRule(arrayTypeDefinition.getMinItems().intValue()));
        }
        return rule;
    }

    @Override
    public Rule visitUnion(UnionResolvedType unionTypeDefinition) {
        List<ResolvedType> of = unionTypeDefinition.of();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        boolean oldStrictMode = this.strictMode;
        this.strictMode = true;
        for (ResolvedType resolvedType : of) {
            rules.add(this.generateRule(resolvedType));
        }
        this.strictMode = oldStrictMode;
        return new AnyOfRule(rules);
    }
}

