/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedList;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataAttributes;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.ComponentMetadataResult;

public class ComponentResultTypeAdapter
extends TypeAdapter<ComponentMetadataResult> {
    private static final String METADATA_ATTRIBUTES = "metadataAttributes";
    private static final String FAILURES = "failures";
    private final Gson gson;

    public ComponentResultTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, ComponentMetadataResult result) throws IOException {
        out.beginObject();
        out.name(FAILURES);
        out.beginArray();
        result.getFailures().stream().forEach(f -> this.gson.toJson(f, new TypeToken<MetadataFailure>(){}.getType(), out));
        out.endArray();
        out.name(METADATA_ATTRIBUTES);
        this.gson.toJson((Object)result.getMetadataAttributes(), new TypeToken<MetadataAttributes>(){}.getType(), out);
        if (result.isOperation()) {
            out.name("type").value("OPERATION");
            out.name("component");
            this.gson.toJson(result.getModel(), new TypeToken<OperationModel>(){}.getType(), out);
        } else if (result.isSource()) {
            out.name("type").value("SOURCE");
            out.name("component");
            this.gson.toJson(result.getModel(), new TypeToken<SourceModel>(){}.getType(), out);
        }
        out.endObject();
    }

    public ComponentMetadataResult read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        JsonArray failuresArray = json.get(FAILURES).getAsJsonArray();
        LinkedList failures = new LinkedList();
        failuresArray.forEach(f -> failures.add(this.gson.fromJson(f, new TypeToken<MetadataFailure>(){}.getType())));
        if (!failures.isEmpty()) {
            return new ComponentMetadataResult(MetadataResult.failure(failures));
        }
        String type = json.get("type").getAsString();
        JsonObject wrappedComponent = json.get("component").getAsJsonObject();
        ComponentModel model = null;
        if (type.equals("OPERATION")) {
            model = (ComponentModel)this.gson.fromJson((JsonElement)wrappedComponent, new TypeToken<OperationModel>(){}.getType());
        } else if (type.equals("SOURCE")) {
            model = (ComponentModel)this.gson.fromJson((JsonElement)wrappedComponent, new TypeToken<SourceModel>(){}.getType());
        }
        MetadataAttributes attributes = (MetadataAttributes)this.gson.fromJson((JsonElement)json.get(METADATA_ATTRIBUTES).getAsJsonObject(), new TypeToken<MetadataAttributes>(){}.getType());
        return new ComponentMetadataResult(MetadataResult.success((Object)ComponentMetadataDescriptor.builder((ComponentModel)model).withAttributes(attributes).build()));
    }
}

