/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunction
implements Callable {
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        if (arguments[0] instanceof Literal) {
            try {
                StringValue name = (StringValue)((Literal)arguments[0]).getValue();
                boolean is30 = this.getRetainedStaticContext().getXPathVersion() >= 30;
                StructuredQName qName = StructuredQName.fromLexicalQName(name.getStringValue(), false, is30, this.getRetainedStaticContext());
                String uri = qName.getURI();
                String local = qName.getLocalPart();
                if (uri.equals("http://www.w3.org/1999/XSL/Transform") && (local.equals("version") || local.equals("vendor") || local.equals("vendor-url") || local.equals("product-name") || local.equals("product-version") || local.equals("supports-backwards-compatibility") || local.equals("xpath-version") || local.equals("xsd-version"))) {
                    String result = SystemProperty.getProperty(uri, local, this.getRetainedStaticContext());
                    return StringLiteral.makeLiteral(new StringValue(result));
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return null;
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue name = (StringValue)arguments[0].head();
        try {
            boolean is30 = this.getRetainedStaticContext().getXPathVersion() >= 30;
            StructuredQName qName = StructuredQName.fromLexicalQName(name.getStringValue(), false, is30, this.getRetainedStaticContext());
            return new StringValue(SystemProperty.getProperty(qName.getURI(), qName.getLocalPart(), this.getRetainedStaticContext()));
        }
        catch (XPathException err) {
            throw new XPathException("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
        }
    }

    private boolean allowsEarlyEvaluation(Sequence[] arguments, XPathContext context) throws XPathException {
        StringValue name = (StringValue)arguments[0].head();
        try {
            boolean is30 = this.getRetainedStaticContext().getXPathVersion() >= 30;
            StructuredQName qName = StructuredQName.fromLexicalQName(name.getStringValue(), false, is30, this.getRetainedStaticContext());
            String uri = qName.getURI();
            String local = qName.getLocalPart();
            return uri.equals("http://www.w3.org/1999/XSL/Transform") && (local.equals("version") || local.equals("vendor") || local.equals("vendor-url") || local.equals("product-name") || local.equals("product-version") || local.equals("supports-backwards-compatibility") || local.equals("xpath-version") || local.equals("xsd-version"));
        }
        catch (XPathException err) {
            throw new XPathException("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
        }
    }

    public static String yesOrNo(boolean whatever) {
        return whatever ? "yes" : "no";
    }

    public static String getProperty(String uri, String local, RetainedStaticContext rsc) {
        Configuration config = rsc.getConfiguration();
        String edition = rsc.getPackageData().getTargetEdition();
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (local.equals("version")) {
                return rsc.getXPathVersion() >= 30 ? "3.0" : "2.0";
            }
            if (local.equals("vendor")) {
                return Version.getProductVendor();
            }
            if (local.equals("vendor-url")) {
                return Version.getWebSiteAddress();
            }
            if (local.equals("product-name")) {
                return Version.getProductName();
            }
            if (local.equals("product-version")) {
                return Version.getProductVariantAndVersion(edition);
            }
            if (local.equals("is-schema-aware")) {
                boolean schemaAware = rsc.getPackageData().isSchemaAware();
                return SystemProperty.yesOrNo(schemaAware);
            }
            if (local.equals("supports-serialization")) {
                return SystemProperty.yesOrNo(!"JS".equals(edition));
            }
            if (local.equals("supports-backwards-compatibility")) {
                return "yes";
            }
            if (local.equals("supports-namespace-axis")) {
                return "yes";
            }
            if (local.equals("supports-streaming")) {
                return SystemProperty.yesOrNo("EE".equals(edition) && rsc.getXPathVersion() >= 30 && config.isLicensedFeature(2) && !config.getConfigurationProperty("http://saxon.sf.net/feature/streamability").equals("off"));
            }
            if (local.equals("supports-dynamic-evaluation")) {
                return SystemProperty.yesOrNo(!"JS".equals(edition) && rsc.getXPathVersion() >= 30 && config.isLicensedFeature(8));
            }
            if (local.equals("supports-higher-order-functions")) {
                return SystemProperty.yesOrNo(!"JS".equals(edition) && !"HE".equals(edition) && rsc.getXPathVersion() >= 30 && config.isLicensedFeature(8));
            }
            if (local.equals("xpath-version")) {
                String v = rsc.getXPathVersion() + "";
                return v.charAt(0) + "." + v.charAt(1);
            }
            if (local.equals("xsd-version")) {
                return rsc.getConfiguration().getXsdVersion() == 10 ? "1.0" : "1.1";
            }
            return "";
        }
        if (uri.isEmpty() && config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
            String val = System.getProperty(local);
            return val == null ? "" : val;
        }
        return "";
    }
}

