/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLSequence
extends StyleElement {
    private Expression select;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return this.isXslt30Processor();
    }

    public boolean mayContainFallback() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null && !this.isXslt30Processor()) {
            this.reportAbsence("select");
            this.select = Literal.makeEmptySequence();
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLFallback) continue;
            if (this.isXslt30Processor()) {
                if (this.select == null) break;
                this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", "XTSE3185");
                break;
            }
            this.compileError("The only child node allowed for " + this.getDisplayName() + " is an xsl:fallback instruction", "XTSE0010");
            break;
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.select == null) {
            this.select = this.compileSequenceConstructor(exec, decl, false);
        }
        return this.select;
    }
}

