/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.internal.handler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.api.utils.TypeResolver;
import org.mule.metadata.java.internal.handler.BaseClassHandler;

public class CollectionClassHandler
extends BaseClassHandler {
    public CollectionClassHandler() {
        super(Iterable.class, Iterator.class);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder) {
        Optional<Type> type = this.getGenericType(clazz, genericTypes);
        ArrayTypeBuilder arrayType = typeBuilder.arrayType().with((TypeAnnotation)new ClassInformationAnnotation(clazz));
        context.addTypeBuilder(clazz, (TypeBuilder<?>)arrayType);
        if (type.isPresent()) {
            Type arrayGenericType = type.get();
            Optional<TypeBuilder<?>> mayBeBuilder = context.getTypeBuilder(arrayGenericType);
            if (mayBeBuilder.isPresent()) {
                arrayType.of(mayBeBuilder.get());
            } else {
                typeHandlerManager.handle(arrayGenericType, context, arrayType.of());
            }
        } else {
            arrayType.of().anyType();
        }
        return arrayType;
    }

    public Optional<Type> getGenericType(Class<?> clazz, List<Type> genericTypes) {
        ParameterizedType parametrizedType = TypeResolver.getGenericSuperclass(clazz, Iterable.class);
        if (genericTypes.isEmpty()) {
            if (parametrizedType != null) {
                return Optional.of(parametrizedType.getActualTypeArguments()[0]);
            }
            return Optional.empty();
        }
        return Optional.of(genericTypes.get(0));
    }
}

