/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model.config;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationPropertiesProvider;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationProperty;

public class CompositeConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider {
    private List<ConfigurationPropertiesProvider> configurationPropertiesProviders;

    public CompositeConfigurationPropertiesProvider(List<ConfigurationPropertiesProvider> configurationPropertiesProviders) {
        this.configurationPropertiesProviders = configurationPropertiesProviders;
    }

    @Override
    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        for (ConfigurationPropertiesProvider configurationPropertiesProvider : this.configurationPropertiesProviders) {
            Optional<ConfigurationProperty> configurationAttribute = configurationPropertiesProvider.getConfigurationProperty(configurationAttributeKey);
            if (!configurationAttribute.isPresent()) continue;
            return configurationAttribute;
        }
        return Optional.empty();
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("configuration-attribute provider composed of (");
        for (ConfigurationPropertiesProvider configurationPropertiesProvider : this.configurationPropertiesProviders) {
            stringBuilder.append(configurationPropertiesProvider.getDescription());
            stringBuilder.append(", ");
        }
        stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        return stringBuilder.append(")").toString();
    }
}

