/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.processor;

import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PostRegistrationActionsPostProcessor
implements BeanPostProcessor {
    private final MuleRegistryHelper registryHelper;
    private final Set<String> seenBeanNames = new HashSet<String>();
    private final ConfigurableListableBeanFactory beanFactory;

    public PostRegistrationActionsPostProcessor(MuleRegistryHelper registryHelper, ConfigurableListableBeanFactory beanFactory) {
        this.registryHelper = registryHelper;
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FactoryBean) {
            return bean;
        }
        if (!beanName.startsWith("(inner bean)") && !this.seenBeanNames.contains(beanName)) {
            if (this.beanFactory.containsBeanDefinition(beanName) && this.beanFactory.getBeanDefinition(beanName).isPrototype()) {
                return bean;
            }
            this.seenBeanNames.add(beanName);
            this.registryHelper.postObjectRegistrationActions(bean);
        }
        return bean;
    }
}

