/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.exchange;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.locator.ModelLocator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.exchange.model.ExchangeDependency;
import org.mule.maven.exchange.model.ExchangeModel;
import org.mule.maven.exchange.model.ExchangeModelSerializer;

@Component(role=ModelProcessor.class)
public class ExchangeModelProcessor
implements ModelProcessor {
    public static final String ORG_ID_KEY = "orgId";
    public static final String RAML_FRAGMENT = "raml-fragment";
    private static Logger LOGGER = Logger.getLogger(ExchangeModelProcessor.class.getName());
    private static final String EXCHANGE_JSON = "exchange.json";
    private static final String TEMPORAL_EXCHANGE_XML = ".exchange.xml";
    public static final String PACKAGER_VERSION = "1.0.2";
    public static final String MAVEN_FACADE_SYSTEM_PROPERTY = "-Dexchange.maven.repository.url";
    private ExchangeModelSerializer objectMapper = new ExchangeModelSerializer();
    @Requirement
    private ModelReader modelReader;
    @Requirement
    private ModelLocator modelLocator;

    public void setModelReader(ModelReader modelReader) {
        this.modelReader = modelReader;
    }

    public void setModelLocator(ModelLocator modelLocator) {
        this.modelLocator = modelLocator;
    }

    public File locatePom(File projectDirectory) {
        File pomFile = new File(projectDirectory, EXCHANGE_JSON);
        if (pomFile.exists()) {
            pomFile = new File(pomFile.getParentFile(), TEMPORAL_EXCHANGE_XML);
            try {
                pomFile.createNewFile();
                pomFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("error creating temporal `%s` empty file", TEMPORAL_EXCHANGE_XML), e);
            }
        } else {
            pomFile = this.modelLocator.locatePom(projectDirectory);
        }
        return pomFile;
    }

    public Model read(File file, Map<String, ?> map) throws IOException, ModelParseException {
        return this.read(new FileInputStream(file), map);
    }

    public Model read(InputStream inputStream, Map<String, ?> map) throws IOException, ModelParseException {
        return this.read(new InputStreamReader(inputStream, StandardCharsets.UTF_8), map);
    }

    public Model read(Reader reader, Map<String, ?> options) throws IOException, ModelParseException {
        Object source;
        Object v0 = source = options != null ? options.get("org.apache.maven.model.building.source") : null;
        if (source instanceof ModelSource2 && ((ModelSource2)source).getLocation().endsWith(TEMPORAL_EXCHANGE_XML)) {
            String temporalExchangeXml = ((ModelSource2)source).getLocation();
            File temporaryExchangeXml = new File(temporalExchangeXml);
            File exchangeJson = new File(temporaryExchangeXml.getParent(), EXCHANGE_JSON);
            String exchangeJsonLocation = exchangeJson.getAbsolutePath();
            FileInputStream exchangeJsonInputStream = new FileInputStream(exchangeJson);
            Model mavenModel = this.getModel(exchangeJsonLocation, exchangeJsonInputStream);
            FileModelSource temporalSourceXml = new FileModelSource(exchangeJson);
            options.put("org.apache.maven.model.building.source", temporalSourceXml);
            String data = this.toXmlString(mavenModel);
            FileUtils.fileWrite((File)temporaryExchangeXml, (String)data);
            mavenModel.setPomFile(temporaryExchangeXml);
            return mavenModel;
        }
        return this.modelReader.read(reader, options);
    }

    public static String toPomXml(File exchangeJson) throws IOException {
        ExchangeModelProcessor exchangeModelProcessor = new ExchangeModelProcessor();
        FileInputStream exchangeJsonInputStream = new FileInputStream(exchangeJson);
        Model mavenModel = exchangeModelProcessor.getModel(exchangeJson.getAbsolutePath(), exchangeJsonInputStream);
        return exchangeModelProcessor.toXmlString(mavenModel);
    }

    private Model getModel(String location, InputStream inputStream) throws IOException {
        ExchangeModel model = this.objectMapper.read(inputStream);
        boolean modified = false;
        if (StringUtils.isBlank((String)model.getAssetId())) {
            model.setAssetId(this.dasherize(model.getName()));
            modified = true;
        }
        if (StringUtils.isBlank((String)model.getVersion())) {
            model.setVersion("1.0.0-SNAPSHOT");
            modified = true;
        }
        if (StringUtils.isBlank((String)model.getGroupId())) {
            String orgId = this.guessOrgId(location);
            if (orgId != null) {
                model.setGroupId(orgId);
                modified = true;
            } else {
                throw new RuntimeException("No `groupId` on exchange json or System property `groupId` or being an apivcs project");
            }
        }
        if (modified) {
            LOGGER.log(Level.WARNING, "[WARNING] exchange.json was modified by the build.");
            this.objectMapper.write(model, new File(location));
        }
        Model mavenModel = this.toMavenModel(model);
        if (Boolean.getBoolean("exchange.maven.debug")) {
            System.out.println("Maven Model \n" + this.toXmlString(mavenModel));
        }
        return mavenModel;
    }

    private String guessOrgId(String location) {
        File projectFolder;
        File apiVcsConfigFile;
        String groupId = System.getProperty("groupId");
        if (groupId == null && (apiVcsConfigFile = new File(new File(projectFolder = new File(location).getParentFile(), ".apivcs"), "config.properties")).exists()) {
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(apiVcsConfigFile);){
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            groupId = properties.getProperty(ORG_ID_KEY);
        }
        return groupId;
    }

    public String toXmlString(Model mavenModel) throws IOException {
        StringWriter stringWriter = new StringWriter();
        new MavenXpp3Writer().write((Writer)stringWriter, mavenModel);
        return stringWriter.toString();
    }

    private Model toMavenModel(ExchangeModel model) {
        Model result = new Model();
        result.setModelVersion("4.0.0");
        result.setArtifactId(model.getAssetId());
        result.setGroupId(model.getGroupId());
        result.setName(model.getName());
        result.setVersion(model.getVersion());
        result.setRepositories(Collections.singletonList(this.createExchangeRepository()));
        List dependencies = model.getDependencies().stream().map(this::toMavenDependency).collect(Collectors.toList());
        result.setDependencies(dependencies);
        Build build = new Build();
        build.setDirectory(String.format("${project.basedir}/%s/target", ".exchange_modules_tmp"));
        build.setSourceDirectory("${project.basedir}");
        build.addPlugin(this.createPackagerPlugin(model));
        if (!model.getClassifier().equals(RAML_FRAGMENT)) {
            build.addPlugin(this.createConnectorInvokerPlugin("install"));
            build.addPlugin(this.createConnectorInvokerPlugin("deploy"));
        }
        result.setBuild(build);
        return result;
    }

    private Plugin createConnectorInvokerPlugin(String phase) {
        Plugin result = new Plugin();
        result.setGroupId("org.apache.maven.plugins");
        result.setArtifactId("maven-invoker-plugin");
        result.setVersion("3.2.0");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        this.addSimpleNodeTo("goals", phase, configuration);
        this.addSimpleNodeTo("pom", String.format("${project.basedir}/%s/target/%s/pom.xml", ".exchange_modules_tmp", "rest_connect_workdir"), configuration);
        boolean skipInvoker = Boolean.getBoolean("exchange.maven.restConnect.skip");
        this.addSimpleNodeTo("skipInvocation", Boolean.toString(skipInvoker), configuration);
        Xpp3Dom propertiesNode = new Xpp3Dom("properties");
        this.addSimpleNodeTo("skipDocumentation", "true", propertiesNode);
        this.addSimpleNodeTo("mule.maven.extension.model.disable", "true", propertiesNode);
        configuration.addChild(propertiesNode);
        result.setConfiguration((Object)configuration);
        PluginExecution installConnector = new PluginExecution();
        installConnector.setId("rest-connect-" + phase);
        installConnector.setPhase(phase);
        installConnector.addGoal("run");
        result.addExecution(installConnector);
        return result;
    }

    private void addSimpleNodeTo(String nodeName, String valueNode, Xpp3Dom configuration) {
        Xpp3Dom goalsNode = new Xpp3Dom(nodeName);
        goalsNode.setValue(valueNode);
        configuration.addChild(goalsNode);
    }

    private String dasherize(String name) {
        return name.toLowerCase().replaceAll(" ", "-");
    }

    private Plugin createPackagerPlugin(ExchangeModel model) {
        Plugin result = new Plugin();
        result.setGroupId("org.mule.maven.exchange");
        result.setArtifactId("exchange_api_packager");
        result.setVersion(PACKAGER_VERSION);
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        this.addSimpleNodeTo("classifier", model.getClassifier(), configuration);
        this.addSimpleNodeTo("mainFile", model.getMain(), configuration);
        result.setConfiguration((Object)configuration);
        PluginExecution generateSources = new PluginExecution();
        generateSources.setId("generate-full-api");
        generateSources.setPhase("generate-sources");
        generateSources.addGoal("generate-full-api");
        result.addExecution(generateSources);
        PluginExecution compilePhase = new PluginExecution();
        compilePhase.setId("validate-api");
        compilePhase.setPhase("compile");
        compilePhase.addGoal("validate-api");
        result.addExecution(compilePhase);
        PluginExecution packagePhase = new PluginExecution();
        packagePhase.setId("generate-artifacts");
        packagePhase.setPhase("package");
        packagePhase.addGoal("package-api");
        packagePhase.addGoal("rest-connect");
        result.addExecution(packagePhase);
        return result;
    }

    private Dependency toMavenDependency(ExchangeDependency dep) {
        Dependency result = new Dependency();
        result.setArtifactId(dep.getAssetId());
        result.setGroupId(dep.getGroupId());
        result.setVersion(dep.getVersion());
        result.setClassifier(RAML_FRAGMENT);
        result.setType("zip");
        return result;
    }

    private Repository createExchangeRepository() {
        String url = System.getProperty(MAVEN_FACADE_SYSTEM_PROPERTY, "https://maven.anypoint.mulesoft.com/api/v2/maven");
        Repository repository = new Repository();
        repository.setId("anypoint-exchange-v2");
        repository.setName("Anypoint Exchange");
        repository.setUrl(url);
        repository.setLayout("default");
        return repository;
    }
}

