/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.acegi;

import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.mule.extras.acegi.AcegiAuthenticationAdapter;
import org.mule.extras.acegi.AcegiSecurityContextFactory;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityContextFactory;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.security.UnknownAuthenticationTypeException;

public class AcegiProviderAdapter
implements UMOSecurityProvider,
AuthenticationProvider {
    private AuthenticationProvider delegate;
    private String name;
    private UMOSecurityContextFactory factory;
    private Map securityProperties;

    public AcegiProviderAdapter() {
    }

    public AcegiProviderAdapter(AuthenticationProvider delegate) {
        this.delegate = delegate;
    }

    public AcegiProviderAdapter(AuthenticationProvider delegate, String name) {
        this.delegate = delegate;
        this.name = name;
    }

    public void initialise() throws InitialisationException {
        this.factory = new AcegiSecurityContextFactory();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UMOAuthentication authenticate(UMOAuthentication authentication) throws SecurityException {
        Object auth = null;
        auth = authentication instanceof AcegiAuthenticationAdapter ? ((AcegiAuthenticationAdapter)authentication).getDelegate() : new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials());
        auth = this.delegate.authenticate(auth);
        return new AcegiAuthenticationAdapter((Authentication)auth, this.getSecurityProperties());
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public boolean supports(Class aClass) {
        return UMOAuthentication.class.isAssignableFrom(aClass);
    }

    public AuthenticationProvider getDelegate() {
        return this.delegate;
    }

    public void setDelegate(AuthenticationProvider delegate) {
        this.delegate = delegate;
    }

    public UMOSecurityContext createSecurityContext(UMOAuthentication auth) throws UnknownAuthenticationTypeException {
        return this.factory.create(auth);
    }

    public Map getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(Map securityProperties) {
        this.securityProperties = securityProperties;
    }
}

