/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.acegi.filters.http;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.extras.acegi.AcegiAuthenticationAdapter;
import org.mule.extras.acegi.i18n.AcegiMessages;
import org.mule.impl.security.AbstractEndpointSecurityFilter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.SecurityProviderNotFoundException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UnauthorisedException;
import org.mule.umo.security.UnknownAuthenticationTypeException;
import org.mule.umo.security.UnsupportedAuthenticationSchemeException;

public class HttpBasicAuthenticationFilter
extends AbstractEndpointSecurityFilter {
    protected static final Log logger = LogFactory.getLog((Class)HttpBasicAuthenticationFilter.class);
    private String realm;
    private boolean realmRequired = true;

    public HttpBasicAuthenticationFilter() {
    }

    public HttpBasicAuthenticationFilter(String realm) {
        this.realm = realm;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.realm == null) {
            if (this.isRealmRequired()) {
                throw new InitialisationException(AcegiMessages.authRealmMustBeSetOnFilter(), (Object)this);
            }
            logger.warn((Object)"There is no security realm set, using default: null");
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isRealmRequired() {
        return this.realmRequired;
    }

    public void setRealmRequired(boolean realmRequired) {
        this.realmRequired = realmRequired;
    }

    public void authenticateInbound(UMOEvent event) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        UMOAuthentication authResult;
        String header = event.getMessage().getStringProperty("Authorization", null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header: " + header));
        }
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            authRequest.setDetails(event.getMessage().getProperty("MULE_ENDPOINT"));
            AcegiAuthenticationAdapter umoAuthentication = new AcegiAuthenticationAdapter((Authentication)authRequest);
            try {
                authResult = this.getSecurityManager().authenticate((UMOAuthentication)umoAuthentication);
            }
            catch (AuthenticationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication request for user: " + username + " failed: " + e.toString()));
                }
                this.setUnauthenticated(event);
                throw new UnauthorisedException(CoreMessages.authFailedForUser((Object)username), (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success: " + authResult.toString()));
            }
        } else {
            if (header == null) {
                this.setUnauthenticated(event);
                throw new UnauthorisedException(event.getMessage(), event.getSession().getSecurityContext(), this.getEndpoint(), (UMOEndpointSecurityFilter)this);
            }
            this.setUnauthenticated(event);
            throw new UnsupportedAuthenticationSchemeException(AcegiMessages.basicFilterCannotHandleHeader(header), event.getMessage());
        }
        UMOSecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
    }

    protected void setUnauthenticated(UMOEvent event) {
        String realmHeader = "Basic realm=";
        if (this.realm != null) {
            realmHeader = realmHeader + "\"" + this.realm + "\"";
        }
        UMOMessage msg = event.getMessage();
        msg.setProperty("WWW-Authenticate", (Object)realmHeader);
        msg.setIntProperty("http.status", 401);
    }

    public void authenticateOutbound(UMOEvent event) throws SecurityException, SecurityProviderNotFoundException {
        if (event.getSession().getSecurityContext() == null) {
            if (this.isAuthenticate()) {
                throw new UnauthorisedException(event.getMessage(), event.getSession().getSecurityContext(), event.getEndpoint(), (UMOEndpointSecurityFilter)this);
            }
            return;
        }
        UMOAuthentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (this.isAuthenticate()) {
            auth = this.getSecurityManager().authenticate(auth);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success: " + auth.toString()));
            }
        }
        StringBuffer header = new StringBuffer(128);
        header.append("Basic ");
        String token = auth.getCredentials().toString();
        header.append(new String(Base64.encodeBase64((byte[])token.getBytes())));
        event.getMessage().setStringProperty("Authorization", header.toString());
    }
}

