/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeTypeParseException;
import org.ibeans.api.CallInterceptor;
import org.ibeans.api.ClientAnnotationHandler;
import org.ibeans.api.IBeanInvocationData;
import org.ibeans.api.IBeanInvoker;
import org.ibeans.api.IBeansException;
import org.ibeans.impl.DefaultIBeanInvoker;
import org.ibeans.impl.TemplateAnnotationHandler;
import org.ibeans.impl.support.util.Utils;
import org.ibeans.spi.ErrorFilterFactory;
import org.ibeans.spi.ExpressionParser;
import org.ibeans.spi.IBeansPlugin;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.registry.Registry;
import org.mule.module.ibeans.spi.ExpressionErrorFilterFactory;
import org.mule.module.ibeans.spi.MuleCallAnnotationHandler;
import org.mule.module.ibeans.spi.MuleExpressionParser;
import org.mule.module.ibeans.spi.MuleMockCallAnnotationHandler;
import org.mule.module.ibeans.spi.MuleRequestMessage;
import org.mule.module.ibeans.spi.MuleResponseMessage;
import org.mule.module.ibeans.spi.MuleResponseTransformInterceptor;
import org.mule.registry.RegistryMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleIBeansPlugin
implements IBeansPlugin<MuleRequestMessage, MuleResponseMessage> {
    private MuleContext muleContext;
    private Map<String, Object> properties;
    private MuleExpressionParser expressionParser;
    private MuleCallAnnotationHandler callAnnotationHandler;
    private TemplateAnnotationHandler templateAnnotationHandler;
    private MuleResponseTransformInterceptor responseTransformInterceptor;
    private List<ErrorFilterFactory> errorFilterFactories;

    public MuleIBeansPlugin(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.callAnnotationHandler = new MuleCallAnnotationHandler(muleContext);
        this.expressionParser = new MuleExpressionParser(muleContext);
        this.properties = new RegistryMap((Registry)muleContext.getRegistry());
        this.templateAnnotationHandler = new TemplateAnnotationHandler((IBeansPlugin)this);
        this.responseTransformInterceptor = new MuleResponseTransformInterceptor(muleContext, (ExpressionParser)this.expressionParser);
        this.errorFilterFactories = new ArrayList<ErrorFilterFactory>();
        this.errorFilterFactories.add(new ExpressionErrorFilterFactory(muleContext));
    }

    public CallInterceptor getResponseTransformInterceptor() throws IBeansException {
        return this.responseTransformInterceptor;
    }

    public IBeanInvoker<MuleCallAnnotationHandler, TemplateAnnotationHandler> getIBeanInvoker() throws IBeansException {
        return new DefaultIBeanInvoker((ClientAnnotationHandler)this.callAnnotationHandler, this.templateAnnotationHandler);
    }

    public IBeanInvoker<MuleMockCallAnnotationHandler, TemplateAnnotationHandler> getMockIBeanInvoker(Object mock) throws IBeansException {
        return new DefaultIBeanInvoker((ClientAnnotationHandler)new MuleMockCallAnnotationHandler(this.muleContext, mock, this), this.templateAnnotationHandler);
    }

    public List<ErrorFilterFactory> getErrorFilterFactories() {
        return this.errorFilterFactories;
    }

    public Map getProperties() {
        return this.properties;
    }

    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public void addInterceptors(LinkedList<CallInterceptor> interceptors) {
    }

    public MuleRequestMessage createRequest(IBeanInvocationData data) throws IBeansException {
        List payload = data.getPayloads().size() == 1 ? data.getPayloads().get(0) : data.getPayloads();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)payload, this.muleContext);
        for (Map.Entry entry : data.getHeaderParams().entrySet()) {
            if (entry.getValue() == null) continue;
            message.setOutboundProperty((String)entry.getKey(), entry.getValue());
        }
        message.setOutboundProperty("ibeans.uri.params", (Object)data.getUriParams());
        for (DataSource dataSource : data.getAttachments()) {
            try {
                message.addAttachment(dataSource.getName(), new DataHandler(dataSource));
            }
            catch (Exception e) {
                throw new IBeansException((Throwable)e);
            }
        }
        MuleRequestMessage request = new MuleRequestMessage(data, (MuleMessage)message);
        request.setTimeout(Utils.getInt(data.getPropertyParams().get("timeout"), (int)-1));
        return request;
    }

    public MuleResponseMessage createResponse(Object payload, Map<String, Object> headers, Map<String, DataHandler> attachments) throws IBeansException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, this.muleContext);
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                try {
                    message.setInboundProperty(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    throw new IBeansException((Throwable)e);
                }
            }
        }
        if (attachments != null) {
            for (Map.Entry<String, Object> entry : attachments.entrySet()) {
                try {
                    message.addAttachment(entry.getKey(), (DataHandler)entry.getValue());
                }
                catch (Exception e) {
                    throw new IBeansException((Throwable)e);
                }
            }
        }
        try {
            return new MuleResponseMessage((MuleMessage)message);
        }
        catch (MimeTypeParseException e) {
            throw new IBeansException((Throwable)e);
        }
    }
}

