/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi;

import java.lang.reflect.Method;
import org.ibeans.annotation.Return;
import org.ibeans.api.AbstractCallInterceptor;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Response;
import org.ibeans.spi.ExpressionParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.module.ibeans.spi.MuleResponseMessage;
import org.mule.module.ibeans.spi.support.DataTypeConverter;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.transformer.types.DataTypeFactory;

public class MuleResponseTransformInterceptor
extends AbstractCallInterceptor {
    private MuleContext muleContext;
    private ExpressionParser parser;

    public MuleResponseTransformInterceptor(MuleContext muleContext, ExpressionParser parser) {
        this.muleContext = muleContext;
        this.parser = parser;
    }

    public void afterCall(InvocationContext invocationContext) throws Throwable {
        Object finalResult;
        MuleResponseMessage result = (MuleResponseMessage)invocationContext.getResponse();
        if (result == null || result.getPayload() == null || invocationContext.getMethod().getReturnType().equals(Void.TYPE)) {
            return;
        }
        Method method = invocationContext.getMethod();
        if (method.getName().startsWith("ibean")) {
            invocationContext.setResult(result.getPayload());
            return;
        }
        DataType requiredType = DataTypeConverter.convertIBeansToMule(invocationContext.getReturnType());
        if (method.getAnnotation(Return.class) != null) {
            String returnExpression = method.getAnnotation(Return.class).value();
            finalResult = this.handleReturnAnnotation(returnExpression, result, invocationContext);
            DataType finalType = DataTypeFactory.createFromObject((Object)finalResult);
            if (!requiredType.isCompatibleWith(finalType)) {
                Transformer transformer = this.muleContext.getRegistry().lookupTransformer(finalType, requiredType);
                finalResult = transformer.transform(finalResult);
            }
        } else if (requiredType.getType().equals(MuleMessage.class)) {
            finalResult = result.getMessage();
        } else if (requiredType.getType().equals(Response.class)) {
            finalResult = result;
        } else {
            DataType sourceType = DataTypeFactory.createFromObject((Object)result.getMessage());
            if (requiredType.isCompatibleWith(sourceType)) {
                finalResult = result.getPayload();
            } else {
                Transformer transformer = this.muleContext.getRegistry().lookupTransformer(sourceType, requiredType);
                finalResult = transformer.transform(result.getPayload());
            }
        }
        invocationContext.setResult(finalResult);
    }

    protected Object handleReturnAnnotation(String expr, Response message, InvocationContext ctx) {
        if (this.parser.hasUriTokens(expr)) {
            expr = this.parser.parseUriTokens(ctx.getIBeanConfig().getUriParams(), expr);
            expr = this.parser.parseUriTokens(ctx.getIBeanConfig().getHeaderParams(), expr);
            expr = this.parser.parseUriTokens(ctx.getIBeanConfig().getPropertyParams(), expr);
        }
        if (ctx.getMethod().getReturnType().equals(Boolean.class)) {
            return new ExpressionFilter(expr).accept(((MuleResponseMessage)message).getMessage());
        }
        return this.parser.evaluate(expr, message);
    }
}

