/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.api.ClientAnnotationHandler;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Request;
import org.ibeans.api.Response;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultExceptionPayload;
import org.mule.module.ibeans.config.IBeanFlowConstruct;
import org.mule.module.ibeans.spi.MuleRequestMessage;
import org.mule.module.ibeans.spi.MuleResponseMessage;
import org.mule.transport.NullPayload;
import org.mule.util.StringMessageUtils;

public class MuleCallAnnotationHandler
implements ClientAnnotationHandler {
    public static final String DEFAULT_METHOD_NAME_TOKEN = "default";
    protected static Log logger = LogFactory.getLog(MuleCallAnnotationHandler.class);
    private MuleContext muleContext;
    private IBeanFlowConstruct flow;
    protected Map<String, InterfaceBinding> routers = new HashMap<String, InterfaceBinding>();

    public MuleCallAnnotationHandler(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setFlow(IBeanFlowConstruct flow) {
        this.flow = flow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRouterForInterface(InterfaceBinding router) {
        if (router instanceof MuleContextAware) {
            ((MuleContextAware)router).setMuleContext(this.muleContext);
        }
        if (router.getMethod() == null) {
            if (this.routers.size() != 0) throw new IllegalArgumentException(CoreMessages.mustSetMethodNamesOnBinding().getMessage());
            this.routers.put(DEFAULT_METHOD_NAME_TOKEN, router);
            return;
        } else {
            this.routers.put(router.getMethod(), router);
        }
    }

    public Response invoke(InvocationContext ctx) throws Exception {
        InterfaceBinding router = this.routers.get(ctx.getMethod().toString());
        if (router == null) {
            throw new IllegalArgumentException(CoreMessages.cannotFindBindingForMethod((String)ctx.getMethod().getName()).toString());
        }
        router.getEndpoint().getProperties().putAll(ctx.getIBeanDefaultConfig().getPropertyParams());
        Request req = ctx.getRequest();
        MuleMessage message = ((MuleRequestMessage)req).getMessage();
        if (logger.isTraceEnabled()) {
            try {
                logger.trace((Object)("Message Before invoking " + ctx.getMethod() + ": \n" + StringMessageUtils.truncate((String)StringMessageUtils.toString((Object)message.getPayload()), (int)2000, (boolean)false)));
                logger.trace((Object)("Message Headers: \n" + StringMessageUtils.headersToString((MuleMessage)message)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MuleEvent replyEvent = null;
        try {
            replyEvent = router.process((MuleEvent)new DefaultMuleEvent(message, router.getEndpoint().getExchangePattern(), (FlowConstruct)this.flow));
        }
        catch (Throwable e) {
            DefaultMuleMessage reply = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.muleContext);
            reply.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload(e));
            return new MuleResponseMessage((MuleMessage)reply);
        }
        return new MuleResponseMessage(replyEvent.getMessage());
    }

    public String getScheme(Method method) {
        InterfaceBinding router = this.routers.get(method.toString());
        if (router == null) {
            throw new IllegalArgumentException(CoreMessages.cannotFindBindingForMethod((String)method.getName()).toString());
        }
        return router.getEndpoint().getEndpointURI().getScheme();
    }

    ImmutableEndpoint getEndpointForMethod(Method method) {
        InterfaceBinding router = this.routers.get(method.toString());
        if (router != null) {
            return router.getEndpoint();
        }
        return null;
    }
}

