/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.servlet.MuleReceiverServlet;

public abstract class AbstractServletTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    private Server httpServer;
    private String context;

    public AbstractServletTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources, String context) {
        super(variant, configResources);
        this.context = context;
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.httpServer = new Server(this.httpPort.getNumber());
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.httpServer, "/", 1);
        ServletHolder holder = new ServletHolder(MuleReceiverServlet.class);
        root.addServlet(holder, this.context);
        ContextHandler.Context servletContext = root.getServletContext();
        servletContext.setAttribute("mule.context", (Object)muleContext);
        this.httpServer.start();
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.stop();
        }
    }

    public void doTestBasic(String root) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(root + "/helloworld", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build());
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Hello World", (Object)result.getPayloadAsString());
        result = client.send(root + "/hello", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext), (OperationOptions)HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build());
        Assert.assertEquals((Object)404, (Object)result.getInboundProperty("http.status", (Object)0));
        result = client.send(root + "/helloworld", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext), (OperationOptions)HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build());
        Assert.assertEquals((Object)405, (Object)result.getInboundProperty("http.status", (Object)0));
        result = client.send(root + "/helloworld", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.DELETE.name()).disableStatusCodeValidation().build());
        Assert.assertEquals((Object)"Hello World Delete", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
    }
}

