/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ContextResolverTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private MuleClient client;
    private String urlMask;

    protected String getConfigFile() {
        return "context-resolver-conf.xml";
    }

    protected void doSetUp() throws Exception {
        this.client = muleContext.getClient();
        this.urlMask = String.format("http://localhost:%d", this.port.getNumber());
    }

    @Test
    public void contextResolver() throws Exception {
        this.assertResolved("/resolve");
    }

    @Test
    public void discoveredContextResolver() throws Exception {
        this.assertResolved("/discovered/resolve");
    }

    private void assertResolved(String url) throws Exception {
        url = this.getUrl(url);
        HttpRequestOptions httpPostRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.GET.name()).disableStatusCodeValidation().build();
        int COUNT = 3;
        String MASK = "{\"message\":\"from contextResolver\",\"number\":%d}";
        for (int i = 0; i < 3; ++i) {
            MuleMessage result = this.client.send(url, (MuleMessage)new DefaultMuleMessage((Object)"", muleContext), (OperationOptions)httpPostRequestOptions);
            Assert.assertThat((Object)result.getInboundProperty("http.status", (Object)0), (Matcher)CoreMatchers.is((Object)200));
            Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)CoreMatchers.is((Object)String.format("{\"message\":\"from contextResolver\",\"number\":%d}", i)));
        }
    }

    private String getUrl(String path) {
        return this.urlMask + path;
    }
}

