/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mule.module.jersey.HelloBean;
import org.mule.module.jersey.exception.BeanBadRequestException;
import org.mule.module.jersey.exception.HelloWorldException;

@Path(value="/helloworld")
public class HelloWorldResource {
    @POST
    @Produces(value={"text/plain"})
    public String sayHelloWorld() {
        return "Hello World";
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/sayHelloWithJson/{name}")
    public HelloBean sayHelloWithJson(@PathParam(value="name") String name) {
        HelloBean hello = new HelloBean();
        hello.setMessage("Hello " + name);
        return hello;
    }

    @DELETE
    @Produces(value={"text/plain"})
    public String deleteHelloWorld() {
        return "Hello World Delete";
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/sayHelloWithUri/{name}")
    public String sayHelloWithUri(@PathParam(value="name") String name) {
        return "Hello " + name;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/sayHelloWithHeader")
    public Response sayHelloWithHeader(@HeaderParam(value="X-Name") String name) {
        return Response.status((int)201).header("X-ResponseName", (Object)name).entity((Object)("Hello " + name)).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/sayHelloWithQuery")
    public String sayHelloWithQuery(@QueryParam(value="name") String name) {
        return "Hello " + name;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/throwException")
    public String throwException() throws HelloWorldException {
        throw new HelloWorldException("This is an exception");
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/throwBadRequestException")
    public HelloBean throwHelloBeanException() throws BeanBadRequestException {
        throw new BeanBadRequestException("beans are rotten");
    }
}

