/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.mule.util.Preconditions;

public class DeferredForwardOutputStream
extends OutputStream {
    private OutputStream delegate;
    private final List<DeferredWrite> deferredWrites = new LinkedList<DeferredWrite>();
    private boolean closeRequested = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        DeferredForwardOutputStream deferredForwardOutputStream = this;
        synchronized (deferredForwardOutputStream) {
            if (this.delegate != null) {
                this.delegate.write(b, off, len);
            } else {
                byte[] buffer = new byte[len];
                System.arraycopy(b, off, buffer, 0, len);
                this.deferredWrites.add(new DeferredWrite(buffer));
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.delegate != null) {
            this.delegate.write(b);
        } else {
            this.deferredWrites.add(new DeferredWrite(new byte[]{(byte)b}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDelegate(OutputStream delegate) throws IOException {
        Preconditions.checkState((this.delegate == null ? 1 : 0) != 0, (String)"delegate can only be set once");
        this.delegate = delegate;
        try {
            for (DeferredWrite deferred : this.deferredWrites) {
                deferred.write(delegate);
            }
            if (this.closeRequested) {
                this.close();
            }
        }
        finally {
            this.deferredWrites.clear();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        } else {
            this.closeRequested = true;
        }
    }

    private class DeferredWrite {
        private final byte[] buffer;

        public DeferredWrite(byte[] buffer) {
            this.buffer = buffer;
        }

        void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.buffer);
        }
    }
}

