/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.io.OutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.module.jersey.DeferredForwardOutputStream;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DeferredForwardOutputStreamTestCase
extends AbstractMuleTestCase {
    private DeferredForwardOutputStream outputStream;
    private byte[] buffer;
    private int len;
    private int off;
    @Mock
    private OutputStream delegate;

    @Before
    public void before() {
        this.outputStream = new DeferredForwardOutputStream();
        this.buffer = RandomStringUtils.randomAlphabetic((int)100).getBytes();
        this.len = this.buffer.length;
        this.off = 0;
    }

    @Test
    public void deferredAfterWrite() throws Exception {
        this.outputStream.write(this.buffer, this.off, this.len);
        this.outputStream.write(this.buffer, this.off, this.len);
        this.outputStream.setDelegate(this.delegate);
        ArgumentCaptor captor = ArgumentCaptor.forClass(byte[].class);
        ((OutputStream)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)2))).write((byte[])captor.capture());
        byte[] captured = (byte[])captor.getValue();
        Assert.assertThat((Object)captured.length, (Matcher)CoreMatchers.is((Object)this.len));
        Assert.assertThat((Object)ArrayUtils.isEquals((Object)this.buffer, (Object)captured), (Matcher)CoreMatchers.is((Object)true));
        this.verifyClose();
    }

    @Test
    public void deferredMixed() throws Exception {
        this.outputStream.write(this.buffer, this.off, this.len);
        this.outputStream.setDelegate(this.delegate);
        this.verifyDeferredDelegation(this.delegate, this.buffer, this.len);
        Mockito.reset((Object[])new OutputStream[]{this.delegate});
        this.outputStream.write(this.buffer, this.off, this.len);
        this.verifyDelegation(this.delegate, this.buffer, this.off, this.len);
        this.verifyClose();
    }

    @Test
    public void notDeferred() throws Exception {
        this.outputStream.setDelegate(this.delegate);
        this.outputStream.write(this.buffer, this.off, this.len);
        this.outputStream.write(this.buffer, this.off, this.len);
        ((OutputStream)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)2))).write(this.buffer, this.off, this.len);
        this.verifyClose();
    }

    @Test(expected=IllegalStateException.class)
    public void setDelegateTwice() throws Exception {
        this.outputStream.setDelegate(this.delegate);
        this.outputStream.setDelegate(this.delegate);
    }

    @Test(expected=NullPointerException.class)
    public void nullBuffer() throws Exception {
        this.outputStream.write(null, this.off, this.len);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void invalidArgs() throws Exception {
        this.outputStream.write(this.buffer, this.len * 2, this.off);
    }

    @Test
    public void noLength() throws Exception {
        this.buffer = new byte[0];
        this.len = 0;
        this.off = 0;
        this.outputStream.write(this.buffer, this.off, this.len);
        ((OutputStream)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).write(this.buffer, this.off, this.len);
    }

    private void verifyDeferredDelegation(OutputStream delegate, byte[] buffer, int len) throws Exception {
        ArgumentCaptor captor = ArgumentCaptor.forClass(byte[].class);
        ((OutputStream)Mockito.verify((Object)delegate)).write((byte[])captor.capture());
        byte[] captured = (byte[])captor.getValue();
        Assert.assertThat((Object)captured.length, (Matcher)CoreMatchers.is((Object)len));
        Assert.assertThat((Object)ArrayUtils.isEquals((Object)buffer, (Object)captured), (Matcher)CoreMatchers.is((Object)true));
    }

    private void verifyDelegation(OutputStream delegate, byte[] buffer, int off, int len) throws Exception {
        ArgumentCaptor captor = ArgumentCaptor.forClass(byte[].class);
        ((OutputStream)Mockito.verify((Object)delegate)).write((byte[])captor.capture(), Matchers.eq((int)off), Matchers.eq((int)len));
        byte[] captured = (byte[])captor.getValue();
        Assert.assertThat((Object)captured.length, (Matcher)CoreMatchers.is((Object)len));
        Assert.assertThat((Object)ArrayUtils.isEquals((Object)buffer, (Object)captured), (Matcher)CoreMatchers.is((Object)true));
    }

    private void verifyClose() throws Exception {
        this.outputStream.close();
        ((OutputStream)Mockito.verify((Object)this.delegate)).close();
    }
}

