/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class MultipleExceptionMapperTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private String configFile;

    public MultipleExceptionMapperTestCase(String configFile) {
        this.configFile = configFile;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"multiple-exception-mapper-config.xml"}, {"multiple-exception-mapper-http-connector-config.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void mapsToBeanBadRequestException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.port.getNumber() + "/helloworld/throwBadRequestException", this.getTestMuleMessage(), (OperationOptions)this.getHttpOptions());
        Assert.assertEquals((Object)400, (Object)result.getInboundProperty("http.status", (Object)0));
    }

    private HttpRequestOptions getHttpOptions() {
        return HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build();
    }

    @Test
    public void mapsToHelloWorldException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.port.getNumber() + "/helloworld/throwException", this.getTestMuleMessage(), (OperationOptions)this.getHttpOptions());
        Assert.assertEquals((Object)503, (Object)result.getInboundProperty("http.status", (Object)0));
    }
}

