/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class MultipleResourcesTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");

    public MultipleResourcesTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "multiple-resources-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "multiple-resources-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "multiple-resources-http-connector-conf-flow.xml"});
    }

    @Test
    public void testParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleMessage result = client.send(String.format("http://localhost:%d/helloworld/sayHelloWithUri/Dan", this.port.getNumber()), (Object)"", props);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayloadAsString());
        result = client.send(String.format("http://localhost:%d/anotherworld/sayHelloWithUri/Dan", this.port.getNumber()), (Object)"", props);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Bonjour Dan", (Object)result.getPayloadAsString());
    }
}

