/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class DiscoverProvidersTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private String url;

    protected String getConfigFile() {
        return "fruit-resource-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.url = "http://localhost:" + this.port.getNumber();
    }

    @Test
    public void cleanApple() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(this.url + "/tasteApple", DiscoverProvidersTestCase.getTestEvent((Object)"false:true").getMessage(), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"The apple is not bitten but clean"));
    }

    @Test
    public void dirtyApple() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(this.url + "/tasteApple", DiscoverProvidersTestCase.getTestEvent((Object)"true:false").getMessage(), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"The apple is bitten but dirty"));
    }
}

