/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.jersey.HelloWorldCookieResource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class JerseyCookiePropagationTestCase
extends FunctionalTestCase {
    private static String TEST_COOKIE_NAME = "testCookie";
    private static String TEST_COOKIE_VALUE = "somevalue";
    private final boolean useOldTransport;
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    private String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, "jersey-cookie-config-flow.xml"}, {false, "jersey-cookie-http-connector-config-flow.xml"});
    }

    public JerseyCookiePropagationTestCase(boolean useOldTransport, String configFile) {
        this.useOldTransport = useOldTransport;
        this.configFile = configFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testJerseyCookiePropagation() throws Exception {
        MuleMessage result;
        HelloWorldCookieResource jerseyResource = (HelloWorldCookieResource)muleContext.getRegistry().get("jerseyComponent");
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.useOldTransport) {
            Cookie[] cookiesObject = new Cookie[]{new Cookie(null, TEST_COOKIE_NAME, TEST_COOKIE_VALUE)};
            props.put("cookies", cookiesObject);
            props.put("http.method", "POST");
            result = muleContext.getClient().send("http://localhost:" + this.httpPort.getNumber() + "/helloworld", (MuleMessage)this.getTestMessage(props));
        } else {
            props.put("Cookie", String.format("%s=%s", TEST_COOKIE_NAME, TEST_COOKIE_VALUE));
            HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
            result = muleContext.getClient().send("http://localhost:" + this.httpPort.getNumber() + "/helloworld", (MuleMessage)this.getTestMessage(props), (OperationOptions)httpRequestOptions);
        }
        Assert.assertThat((Object)200, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)result.getInboundProperty("http.status", (Object)0))));
        Map<String, javax.ws.rs.core.Cookie> cookies = jerseyResource.getCookies();
        javax.ws.rs.core.Cookie jerseyCookie = jerseyResource.getCookies().get(TEST_COOKIE_NAME);
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)cookies.size())));
        Assert.assertThat((Object)TEST_COOKIE_NAME, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)jerseyCookie.getName())));
        Assert.assertThat((Object)TEST_COOKIE_VALUE, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)jerseyCookie.getValue())));
        Assert.assertThat((Object)TEST_COOKIE_VALUE, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)jerseyResource.getTestCookie())));
    }

    private DefaultMuleMessage getTestMessage(Map<String, Object> props) {
        return new DefaultMuleMessage((Object)"", props, muleContext);
    }
}

