/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.transport.PropertyScope;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class MultipartMessageTestCase
extends FunctionalTestCase {
    private static final String UPLOADED_FILENAME = "uploadedFile";
    private static final String MULTIPART_BOUNDARY = "----------------------------299df9f9431b";
    private static final String MULTIPART_MESSAGE = "------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"uploadedFile\"; filename=\"upload.o\"\r\nContent-Type: application/octet-stream\r\n\r\npart payload\r\n\r\n------------------------------299df9f9431b--\r\n\r\n";
    @Rule
    public DynamicPort port = new DynamicPort("port");

    protected String getConfigResources() {
        return "multipart-message-config.xml";
    }

    @Test
    public void multiPartRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage testMuleMessage = this.getTestMuleMessage("Test Message");
        testMuleMessage.setPayload((Object)MULTIPART_MESSAGE);
        testMuleMessage.setProperty("Charset", (Object)StandardCharsets.UTF_8.name(), PropertyScope.OUTBOUND);
        testMuleMessage.setProperty("Content-Type", (Object)"multipart/form-data; boundary=----------------------------299df9f9431b", PropertyScope.OUTBOUND);
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().method("POST").build();
        MuleMessage result = client.send(String.format("http://localhost:%d/", this.port.getNumber()), testMuleMessage, (OperationOptions)options);
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)CoreMatchers.is((Object)"Got uploadedFile"));
    }
}

