/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class BasicJerseyTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private String URL = "http://localhost:" + this.port.getNumber() + "%s";

    public BasicJerseyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "basic-conf.xml"}});
    }

    @Test
    public void testBasic() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HttpRequestOptions httpPostRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
        MuleMessage result = client.send(String.format(this.URL, "/helloworld"), this.getTestMuleMessage(), (OperationOptions)httpPostRequestOptions);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Hello World", (Object)result.getPayloadAsString());
        HttpRequestOptions disableValidationOptions = HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build();
        result = client.send(String.format(this.URL, "/hello"), this.getTestMuleMessage(), (OperationOptions)disableValidationOptions);
        Assert.assertEquals((Object)404, (Object)result.getInboundProperty("http.status", (Object)0));
        result = client.send(String.format(this.URL, "/helloworld"), this.getTestMuleMessage(), (OperationOptions)disableValidationOptions);
        Assert.assertEquals((Object)405, (Object)result.getInboundProperty("http.status", (Object)0));
        result = client.send(String.format(this.URL, "/helloworld"), this.getTestMuleMessage(""), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.DELETE.name()).build());
        Assert.assertEquals((Object)"Hello World Delete", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
    }

    @Test
    public void testParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleMessage result = client.send(String.format(this.URL, "/helloworld/sayHelloWithUri/Dan"), (Object)"", props);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayloadAsString());
        result = client.send(String.format(this.URL, "/helloworld/sayHelloWithJson/Dan"), (Object)"", props);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)this.getJsonHelloBean(), (Object)result.getPayloadAsString());
        result = client.send(String.format(this.URL, "/helloworld/sayHelloWithQuery?name=Dan"), (Object)"", props);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayloadAsString());
        props.put("X-Name", "Dan");
        result = client.send(String.format(this.URL, "/helloworld/sayHelloWithHeader"), (Object)"", props);
        Assert.assertEquals((Object)201, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)"Hello Dan", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)"Dan", (Object)result.getInboundProperty("X-ResponseName"));
    }

    @Test
    public void testThrowException() throws Exception {
        this.callThrowException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "This is an exception");
    }

    protected void callThrowException(Integer expectedErrorCode, String expectedData) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(String.format(this.URL, "/helloworld/throwException"), this.getTestMuleMessage(), (OperationOptions)HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build());
        Assert.assertEquals((Object)expectedErrorCode, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertTrue((boolean)result.getPayloadAsString().contains(expectedData));
    }

    protected String getJsonHelloBean() {
        return "{\"message\":\"Hello Dan\",\"number\":0}";
    }
}

