/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class MultipleContextResolverTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private String configFile;

    public MultipleContextResolverTestCase(String configFile) {
        this.configFile = configFile;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"multiple-context-resolver-config.xml"}, {"multiple-context-resolver-http-connector-config.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void supportsMultipleContextResolver() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleMessage result = client.send("http://localhost:" + this.port.getNumber() + "/helloworld/sayHelloWithJson/World", (Object)"Test Message", props);
        Assert.assertEquals((Object)200, (Object)result.getInboundProperty("http.status", (Object)0));
        Assert.assertEquals((Object)this.getHelloWorldMessage(), (Object)result.getPayloadAsString());
    }

    private String getHelloWorldMessage() {
        return "{\"message\":\"Hello World\",\"number\":0}";
    }
}

