/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey.xml_security;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.jersey.xml_security.XmlBlBase;

public class XmlBlDisabledTestCase
extends XmlBlBase {
    @Test
    public void doesNotExpandEntitiesWhenDisabled() throws Exception {
        MuleMessage testMuleMessage = this.getTestMuleMessage("Test Message");
        testMuleMessage.setPayload((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<!DOCTYPE foo[ \n<!ENTITY lol1 \"0101\"> \n]> \n<Quote> \n<fName>FIRST NAME</fName> \n<lName>LAST NAME &lol1;</lName> \n</Quote>");
        testMuleMessage.setProperty("Content-Type", (Object)"application/xml");
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().method("POST").disableStatusCodeValidation().build();
        MuleMessage result = this.client.send(this.url, testMuleMessage, (OperationOptions)options);
        int status = (Integer)result.getInboundProperty("http.status");
        MatcherAssert.assertThat((Object)status, (Matcher)Matchers.not((Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode())));
        MatcherAssert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"0101")));
    }
}

