/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey.xml_security;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.jersey.xml_security.XmlBlBase;
import org.mule.tck.junit4.rule.SystemProperty;

public class XmlBlEnabledTestCase
extends XmlBlBase {
    @Rule
    public final SystemProperty expandEntities = new SystemProperty("mule.xml.expandInternalEntities", "true");

    @Test
    public void expandsEntitiesWhenEnabled() throws Exception {
        MuleMessage testMuleMessage = this.getTestMuleMessage("Test Message");
        testMuleMessage.setPayload((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<!DOCTYPE foo[ \n<!ENTITY lol1 \"0101\"> \n]> \n<Quote> \n<fName>FIRST NAME</fName> \n<lName>LAST NAME &lol1;</lName> \n</Quote>");
        testMuleMessage.setProperty("Content-Type", (Object)"application/xml");
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().method("POST").build();
        MuleMessage result = this.client.send(String.format("http://localhost:%d/service/customer", this.port.getNumber()), testMuleMessage, (OperationOptions)options);
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"password")));
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)CoreMatchers.containsString((String)"0101"));
    }
}

