/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.JerseyRequestTimeoutHandler;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.jersey.DeferredForwardOutputStream;

class MuleResponseWriter
implements ContainerResponseWriter {
    private ContainerResponse response = null;
    private final String requestMethodName;
    private final MuleEvent muleEvent;
    private final JerseyRequestTimeoutHandler requestTimeoutHandler;
    private final DeferredForwardOutputStream outputStream = new DeferredForwardOutputStream();

    MuleResponseWriter(MuleEvent muleEvent, String requestMethodName, ScheduledExecutorService backgroundScheduler) {
        this.muleEvent = muleEvent;
        this.requestMethodName = requestMethodName;
        this.requestTimeoutHandler = new JerseyRequestTimeoutHandler((ContainerResponseWriter)this, backgroundScheduler);
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse response) {
        this.response = response;
        if (contentLength >= 0L) {
            response.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
        }
        MuleMessage muleMessage = this.muleEvent.getMessage();
        for (Map.Entry e : response.getHeaders().entrySet()) {
            muleMessage.setOutboundProperty((String)e.getKey(), (Object)this.getHeaderValue((List)e.getValue()));
        }
        muleMessage.setInvocationProperty("jersey_response", (Object)response);
        muleMessage.setOutboundProperty("http.status", (Object)response.getStatus());
        return this.getOutputStream();
    }

    public boolean suspend(long time, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) {
        return this.requestTimeoutHandler.suspend(time, unit, handler);
    }

    public void setSuspendTimeout(long time, TimeUnit unit) {
        this.requestTimeoutHandler.setSuspendTimeout(time, unit);
    }

    public void commit() {
        ContainerResponse current = this.response;
        if (current != null) {
            if ("HEAD".equals(this.requestMethodName) && current.hasEntity()) {
                current.setEntity(null);
            }
            this.requestTimeoutHandler.close();
        }
    }

    public void failure(Throwable error) {
        this.requestTimeoutHandler.close();
    }

    public boolean enableResponseBuffering() {
        return true;
    }

    private String getHeaderValue(List<Object> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(o);
        }
        return sb.toString();
    }

    DeferredForwardOutputStream getOutputStream() {
        return this.outputStream;
    }
}

