/*
 * $Id: JotmTransactionManagerFactory.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.extras.jotm;

import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.Jotm;

import javax.transaction.TransactionManager;

/**
 * This factory retrieves the transaction manager for <a
 * href="http://jotm.objectweb.org">JOTM </a>. If an existing JOTM instance exists
 * (for example if running on JOnAS) it will retrieve it, else if will create a new
 * local JOTM instance.
 * 
 * @author Guillaume Nodet
 * @version $Revision: 3798 $
 */
public class JotmTransactionManagerFactory implements UMOTransactionManagerFactory
{
    private TransactionManager jotmCurrent;

    public JotmTransactionManagerFactory()
    {
        super();
    }

    /**
     * Retrieves the JOTM Current object that implements the TransactionManager
     * interface.
     * 
     * @see org.mule.umo.manager.UMOTransactionManagerFactory#create()
     */
    public synchronized TransactionManager create() throws Exception
    {
        if (jotmCurrent == null)
        {
            // check for already active JOTM instance
            jotmCurrent = Current.getCurrent();
            // if none found, create new local JOTM instance
            if (jotmCurrent == null)
            {
                jotmCurrent = new Jotm(true, false).getTransactionManager();
            }
        }
        return jotmCurrent;
    }

}
