/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.util.ComponentLocationProvider;

public class LocatedMuleException
extends MuleException {
    private static final long serialVersionUID = 6941498759267936649L;

    public LocatedMuleException(Object component) {
        this.setLocation(component);
    }

    public LocatedMuleException(I18nMessage message, Object component) {
        super(message);
        this.setLocation(component);
    }

    public LocatedMuleException(I18nMessage message, Throwable cause, Object component) {
        super(message, cause);
        this.setLocation(component);
    }

    public LocatedMuleException(Throwable cause, Object component) {
        super(cause);
        this.setLocation(component);
    }

    protected void setLocation(Object component) {
        if (component != null) {
            this.addInfo("Element", this.resolveProcessorPath(component));
        }
    }

    protected String resolveProcessorPath(Object component) {
        if (component instanceof NamedObject) {
            return ComponentLocationProvider.resolveProcessorRepresentation("app", "/" + ((NamedObject)component).getName(), component);
        }
        return ComponentLocationProvider.resolveProcessorRepresentation("app", component == null ? "null" : component.toString(), component);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        String str = obj.getClass().getName();
        if (obj instanceof NameableObject) {
            str = str + String.format(" '%s'", ((NameableObject)obj).getName());
        }
        return str;
    }
}

