/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component.location;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;

public class LocationTestCase {
    @Test
    public void invalidLocationGlobalName() {
        Consumer<String> locationBuilderConsumer = this.globalNameLocationConsumer();
        this.testInvalidParts(locationBuilderConsumer);
    }

    @Test
    public void invalidLocationPart() {
        Consumer<String> locationBuilderConsumer = this.partLocationConsumer();
        this.testInvalidParts(locationBuilderConsumer);
    }

    @Test
    public void validLocationGlobalName() {
        Consumer<String> locationBuilderConsumer = this.globalNameLocationConsumer();
        this.testValidParts(locationBuilderConsumer);
    }

    @Test
    public void validLocationPart() {
        Consumer<String> locationBuilderConsumer = this.partLocationConsumer();
        this.testValidParts(locationBuilderConsumer);
    }

    private void testValidParts(Consumer<String> locationBuilderConsumer) {
        this.validLocation("lala", locationBuilderConsumer);
        this.validLocation("la\\la", locationBuilderConsumer);
        this.validLocation("la:la", locationBuilderConsumer);
        this.validLocation("\\lala:", locationBuilderConsumer);
        this.validLocation("lal$a", locationBuilderConsumer);
        this.validLocation("l$ala", locationBuilderConsumer);
    }

    private Consumer<String> globalNameLocationConsumer() {
        return part -> Location.builder().globalName(part).build();
    }

    private Consumer<String> partLocationConsumer() {
        return part -> Location.builder().globalName("globalName").addPart(part).build();
    }

    private void testInvalidParts(Consumer<String> locationBuilderConsumer) {
        this.invalidLocation("la/la", locationBuilderConsumer);
        this.invalidLocation("lala}", locationBuilderConsumer);
        this.invalidLocation("{lala", locationBuilderConsumer);
        this.invalidLocation("[lala", locationBuilderConsumer);
        this.invalidLocation("lala]", locationBuilderConsumer);
        this.invalidLocation("l#ala", locationBuilderConsumer);
        this.invalidLocation("[l#ala/", locationBuilderConsumer);
    }

    private void invalidLocation(String location, Consumer<String> locationBuilderConsumer) {
        try {
            locationBuilderConsumer.accept(location);
            Assert.fail((String)String.format("Location part %s should not be valid", location));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void validLocation(String location, Consumer<String> locationBuilderConsumer) {
        locationBuilderConsumer.accept(location);
    }
}

