/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.ConnectionElementDeclaration;
import org.mule.runtime.api.app.declaration.GlobalElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterGroupElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.RouteElementDeclaration;
import org.mule.runtime.api.app.declaration.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConnectionElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConstructElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.OperationElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.RouteElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.SourceElementDeclarer;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;

public class ArtifactDeclarationJsonSerializerTestCase {
    public static final String EXPECTED_ARTIFACT_DECLARATION_JSON = "declaration/artifact-declaration.json";
    private ArtifactDeclaration applicationDeclaration;

    @Before
    public void setup() {
        this.applicationDeclaration = this.createArtifact();
    }

    @Test
    public void serializationTest() throws IOException {
        String expected = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(EXPECTED_ARTIFACT_DECLARATION_JSON));
        String json = ArtifactDeclarationJsonSerializer.getDefault((boolean)true).serialize(this.applicationDeclaration);
        MatcherAssert.assertThat((String)json, (Object)json.trim(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)expected.trim())));
    }

    @Test
    public void serializeDeserializeTest() throws IOException {
        ArtifactDeclarationJsonSerializer serializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String json = serializer.serialize(this.applicationDeclaration);
        ArtifactDeclaration artifactDeclaration = serializer.deserialize(json);
        MatcherAssert.assertThat((String)json, (Object)this.applicationDeclaration, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)artifactDeclaration)));
    }

    private ArtifactDeclaration createArtifact() {
        ElementDeclarer db = ElementDeclarer.forExtension((String)"Database");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer sockets = ElementDeclarer.forExtension((String)"Sockets");
        ElementDeclarer core = ElementDeclarer.forExtension((String)"Mule Core");
        ElementDeclarer wsc = ElementDeclarer.forExtension((String)"Web Service Consumer");
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)db.newConnection("derby-connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("poolingProfile", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxPoolSize", "10").build()).withParameter("connectionProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("first", "propertyOne").withParameter("second", "propertyTwo").build()).withParameter("database", "target/muleEmbeddedDB").withParameter("create", "true").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener-connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("host", "localhost").withParameter("port", "49019").withParameter("protocol", "HTTPS").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("request-config").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request-connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("host", "localhost").withParameter("port", "49020").withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", "user").withParameter("password", "pass").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", "1000").withParameter("keepAlive", "true").withParameter("receiveBufferSize", "1024").withParameter("sendBufferSize", "1024").withParameter("clientTimeout", "1000").withParameter("linger", "1000").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testFlow").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("initialState", "stopped").getDeclaration())).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").withParameter("redeliveryPolicy", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxRedeliveryCount", "2").withParameter("useSecureHash", "true").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("blocking", "true").withParameter("count", "1").withParameter("frequency", "0").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", "<![CDATA[#[{{'content-type' : 'text/plain'}}]]]>").withParameter("body", "<![CDATA[#[\n                    %dw 1.0\n                    output application/json\n                    input payload application/xml\n                    %var baseUrl=\"http://sample.cloudhub.io/api/v1.0/\"\n                    ---\n                    using (pageSize = payload.getItemsResponse.PageInfo.pageSize) {\n                         links: [\n                            {\n                                href: fullUrl,\n                                rel : \"self\"\n                            }\n                         ],\n                         collection: {\n                            size: pageSize,\n                            items: payload.getItemsResponse.*Item map {\n                                id: $.id,\n                                type: $.type,\n                                name: $.name\n                            }\n                         }\n                    }\n                ]]>").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("choice").withRoute((RouteElementDeclaration)((RouteElementDeclarer)core.newRoute("when").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expression", "#[true]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration()).getDeclaration())).withRoute("otherwise", declarer -> declarer.withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("collection", "#[myCollection]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()))).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", "/nested").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", "POST").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("insert").withConfig("dbConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME, DESCRIPTION) VALUES (777, 'Pluto', :description)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "description").withParameter("type", "CLOB").build()).build()).withParameter("inputParameters", "#[{{'description' : payload}}]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)sockets.newOperation("sendAndReceive").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("target", "myVar").withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-in-memory-stream").withParameter("bufferSizeIncrement", "8").withParameter("bufferUnit", "KB").withParameter("initialBufferSize", "51").withParameter("maxBufferSize", "1000").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)wsc.newOperation("consume").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("operation", "GetCitiesByCountry").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("attachments", "#[{}]").withParameter("headers", "#[{\"headers\": {con#headerIn: \"Header In Value\",con#headerInOut: \"Header In Out Value\"}]").withParameter("body", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }
}

