/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.MultiMap;

public class MultiMapTestCase {
    protected static final String KEY_1 = "key1";
    protected static final String KEY_2 = "key2";
    protected static final String KEY_3 = "key3";
    protected static final String VALUE_1 = "value1";
    protected static final String VALUE_2 = "value2";
    protected MultiMap<String, String> multiMap = this.getMultiMap();

    protected MultiMap<String, String> getMultiMap() {
        return new MultiMap();
    }

    @Test
    public void putAndGet() {
        Assert.assertThat((Object)this.multiMap.put((Object)KEY_1, (Object)VALUE_1), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)this.multiMap.get((Object)KEY_1), (Matcher)Is.is((Object)VALUE_1));
        Assert.assertThat((Object)this.multiMap.getAll((Object)KEY_1), (Matcher)Is.is(Arrays.asList(VALUE_1)));
    }

    @Test
    public void secondPutAddsValue() {
        this.multiMap.put((Object)KEY_1, (Object)VALUE_1);
        Assert.assertThat((Object)this.multiMap.put((Object)KEY_1, (Object)VALUE_2), (Matcher)Is.is((Object)VALUE_1));
        Assert.assertThat((Object)this.multiMap.get((Object)KEY_1), (Matcher)Is.is((Object)VALUE_1));
        Assert.assertThat((Object)this.multiMap.getAll((Object)KEY_1), (Matcher)Is.is(Arrays.asList(VALUE_1, VALUE_2)));
    }

    @Test
    public void emptyMapKeySet() {
        Assert.assertThat((Object)this.multiMap.keySet(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.multiMap.keySet(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void keySetReturnAllKeys() {
        this.multiMap.put((Object)KEY_1, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_3, (Object)VALUE_1);
        Assert.assertThat((Object)this.multiMap.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{KEY_1, KEY_2, KEY_3}));
    }

    @Test
    public void emptyValuesKeySet() {
        Assert.assertThat((Object)this.multiMap.values(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.multiMap.values(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableMultiMapFailsOnPut() {
        this.multiMap.toImmutableMultiMap().put((Object)KEY_1, (Object)VALUE_1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableMultiMapFailsOnPutAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_1, VALUE_1);
        this.multiMap.toImmutableMultiMap().putAll(map);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableMultiMapFailsOnRemove() {
        this.multiMap.toImmutableMultiMap().remove((Object)KEY_1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableMultiMapFailsOnClear() {
        this.multiMap.toImmutableMultiMap().clear();
    }

    @Test
    public void valuesReturnsOnlyFirstValue() {
        this.multiMap.put((Object)KEY_1, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_2);
        this.multiMap.put((Object)KEY_3, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_3, (Object)VALUE_2);
        Collection values = this.multiMap.values();
        Assert.assertThat((Object)values, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)values, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{VALUE_1, VALUE_2, VALUE_1}));
    }

    @Test
    public void toListMapValueWithEmptyMap() {
        Assert.assertThat((Object)this.multiMap.toListValuesMap().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void toListMapValueWithSingleValues() {
        this.multiMap.put((Object)KEY_1, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_2);
        Assert.assertThat(this.multiMap.toListValuesMap().get(KEY_1), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_1}));
        Assert.assertThat(this.multiMap.toListValuesMap().get(KEY_2), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_2}));
    }

    @Test
    public void toListMapValueWithSeveralValues() {
        this.multiMap.put((Object)KEY_1, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_1, (Object)VALUE_2);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_2);
        Assert.assertThat(this.multiMap.toListValuesMap().get(KEY_1), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_1, VALUE_2}));
        Assert.assertThat(this.multiMap.toListValuesMap().get(KEY_2), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_1, VALUE_2}));
    }

    @Test
    public void entryList() {
        this.multiMap.put((Object)KEY_1, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_1, (Object)VALUE_2);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_1);
        this.multiMap.put((Object)KEY_2, (Object)VALUE_2);
        Assert.assertThat((Object)this.multiMap.entryList(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)this.multiMap.entryList(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{new EntryMatcher(KEY_1, VALUE_1), new EntryMatcher(KEY_1, VALUE_2), new EntryMatcher(KEY_2, VALUE_1), new EntryMatcher(KEY_2, VALUE_2)}));
    }

    private class EntryMatcher
    extends TypeSafeMatcher<Map.Entry<String, String>> {
        private String expectedKey;
        private String expectedValue;

        public EntryMatcher(String expectedKey, String expectedValue) {
            this.expectedKey = expectedKey;
            this.expectedValue = expectedValue;
        }

        protected boolean matchesSafely(Map.Entry<String, String> item) {
            return this.expectedKey.equals(item.getKey()) && this.expectedValue.equals(item.getValue());
        }

        public void describeTo(Description description) {
            description.appendText("entry with key ").appendValue((Object)this.expectedKey).appendText(" and value ").appendValue((Object)this.expectedValue);
        }

        protected void describeMismatchSafely(Map.Entry<String, String> item, Description mismatchDescription) {
            mismatchDescription.appendText("is an entry with key ").appendValue((Object)item.getKey()).appendText(" and value ").appendValue((Object)item.getValue());
        }
    }
}

