/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.core.internal.policy;

import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.InternalEventContext;

/**
 * Helper class that creates an {@link InternalEvent} maintaining variables from different scopes.
 * 
 * @since 4.0
 */
public class PolicyEventConverter {

  /**
   * Creates a new {@link InternalEvent} based on a message and another event which is used to get the variables and
   * {@link InternalEventContext}
   *
   * @param event provider of the message and session parts of the event
   * @param variablesProviderEvent provider of the variables part of the event
   * @return the created event
   */
  public InternalEvent createEvent(InternalEvent event, InternalEvent variablesProviderEvent) {
    InternalEvent.Builder eventBuilder =
        InternalEvent.builder((InternalEventContext) variablesProviderEvent.getContext()).message(event.getMessage())
            .session(event.getSession());
    eventBuilder.variables(variablesProviderEvent.getVariables());
    return eventBuilder.build();
  }

}
