/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"EventContext"})
@Stories(value={"Response and completion publishers"})
public class DefaultEventContextTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    @Description(value="EventContext response publisher completes with value of result. Also given response publisher completed and there there are no child contexts the completion publisher also completes.")
    public void successWithResult() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        Event event = this.testEvent();
        this.assertCompletionNotDone(parent);
        parent.success(event);
        this.awaitAndAssertResponse(parent, event);
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="EventContext response publisher completes with null result. Also given response publisher completed and there there are no child contexts the completion publisher also completes.")
    public void successNoResult() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        parent.success();
        this.awaittNullResponse(parent);
        this.assertBeforeResponseDone(parent);
        Assert.assertThat((Object)Mono.from((Publisher)parent.getCompletionPublisher()).block(Duration.ofMillis(500L)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="EventContext response publisher completes with error. Also given response publisher completed and there there are no child contexts the completion publisher also completes.")
    public void error() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        RuntimeException exception = new RuntimeException();
        this.assertCompletionNotDone(parent);
        parent.error((Throwable)exception);
        this.assertCompletionDone(parent);
        this.assertResponseDone(parent);
        this.assertBeforeResponseDone(parent);
        this.expectedException.expect(CoreMatchers.is((Object)exception));
        Mono.from((Publisher)parent.getResponsePublisher()).block(Duration.ofMillis(500L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="EventContext beforeResponsePublisher subscribers are notified before responsePublisher subscribers (assuming both are subscribed before response is completed)")
    public void beforeResponse() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        Event event = this.testEvent();
        Latch latch = new Latch();
        Latch lock = new Latch();
        Latch responseSubscriberFired = new Latch();
        Mono.from((Publisher)parent.getBeforeResponsePublisher()).doOnNext(Exceptions.checkedConsumer(e -> {
            lock.countDown();
            latch.await();
        })).subscribe();
        Mono.from((Publisher)parent.getResponsePublisher()).doOnNext(Exceptions.checkedConsumer(e -> responseSubscriberFired.countDown())).subscribe();
        Scheduler testScheduler = muleContext.getSchedulerService().ioScheduler();
        try {
            testScheduler.submit(() -> parent.success(event));
            lock.await();
            Assert.assertThat((Object)responseSubscriberFired.await(500L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)false));
            latch.countDown();
            Assert.assertThat((Object)responseSubscriberFired.await(500L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
            this.awaitAndAssertResponse(parent, event);
            this.awaitCompletion(parent);
        }
        finally {
            testScheduler.stop();
        }
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete.")
    public void childSuccessWithResult() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        Event event = this.testEvent();
        child.success(event);
        this.awaitAndAssertResponse(child, event);
        this.assertCompletionDone(child);
        this.assertCompletionNotDone(parent);
        parent.success(event);
        this.awaitAndAssertResponse(parent, event);
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete, even when child context completes after parent context response.")
    public void childDelayedSuccessWithResult() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        Event event = this.testEvent();
        parent.success(event);
        this.awaitAndAssertResponse(parent, event);
        this.assertCompletionNotDone(parent);
        this.assertCompletionNotDone(child);
        child.success(event);
        this.awaitAndAssertResponse(child, event);
        this.assertCompletionDone(child);
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with no value and all child contexts are complete.")
    public void childSuccessWithNoResult() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        child.success();
        parent.success();
        this.awaittNullResponse(child);
        this.assertCompletionDone(child);
        this.awaittNullResponse(parent);
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with no value and all child contexts are complete, even when child context completes after parent context response.")
    public void childDelayedSuccessWithNoResult() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        parent.success();
        this.awaittNullResponse(parent);
        this.assertCompletionNotDone(parent);
        this.assertCompletionNotDone(child);
        child.success();
        this.awaittNullResponse(child);
        this.assertCompletionDone(child);
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with error and all child contexts are complete.")
    public void childError() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        RuntimeException exception = new RuntimeException();
        child.error((Throwable)exception);
        parent.error((Throwable)exception);
        this.assertResponseDone(child);
        this.assertCompletionDone(child);
        this.assertResponseDone(parent);
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with error and all child contexts are complete, even when child context completes after parent context response.")
    public void childDelayedError() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        RuntimeException exception = new RuntimeException();
        parent.error((Throwable)exception);
        this.assertResponseDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertCompletionNotDone(child);
        child.error((Throwable)exception);
        this.assertCompletionDone(parent);
        this.assertCompletionDone(parent);
        this.expectedException.expect(CoreMatchers.is((Object)exception));
        Mono.from((Publisher)child.getResponsePublisher()).block(Duration.ofMillis(500L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete, even when child is run async with a delay.")
    public void asyncChild() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child1 = DefaultEventContext.child((EventContext)parent);
        Event event = this.testEvent();
        Scheduler testScheduler = muleContext.getSchedulerService().ioScheduler();
        try {
            testScheduler.submit(() -> {
                Thread.sleep(5L);
                child1.success(event);
                return null;
            });
            parent.success(event);
            this.assertCompletionNotDone(child1);
            this.awaitAndAssertResponse(child1, event);
            this.awaitCompletion(child1);
            this.awaitAndAssertResponse(parent, event);
            this.assertCompletionDone(child1);
        }
        finally {
            testScheduler.stop();
        }
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child and grandchild contexts are complete.")
    public void multipleLevelsGrandchildFirst() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        EventContext grandchild = DefaultEventContext.child((EventContext)child);
        this.assertResponseNotDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertResponseNotDone(child);
        this.assertCompletionNotDone(child);
        this.assertResponseNotDone(grandchild);
        this.assertCompletionNotDone(grandchild);
        grandchild.success();
        this.assertResponseNotDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertResponseNotDone(child);
        this.assertCompletionNotDone(child);
        this.assertResponseDone(grandchild);
        this.assertCompletionDone(grandchild);
        child.success();
        this.assertResponseNotDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertResponseDone(child);
        this.assertCompletionDone(child);
        this.assertResponseDone(grandchild);
        this.assertCompletionDone(grandchild);
        parent.success();
        this.assertResponseDone(parent);
        this.assertCompletionDone(parent);
        this.assertResponseDone(child);
        this.assertCompletionDone(child);
        this.assertResponseDone(grandchild);
        this.assertCompletionDone(grandchild);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child and grandchild contexts are complete, even if parent response is available earlier.")
    public void multipleLevelsParentFirst() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        EventContext grandchild = DefaultEventContext.child((EventContext)child);
        this.assertResponseNotDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertResponseNotDone(child);
        this.assertCompletionNotDone(child);
        this.assertResponseNotDone(grandchild);
        this.assertCompletionNotDone(grandchild);
        parent.success();
        this.assertResponseDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertResponseNotDone(child);
        this.assertCompletionNotDone(child);
        this.assertResponseNotDone(grandchild);
        this.assertCompletionNotDone(grandchild);
        child.success();
        this.assertResponseDone(parent);
        this.assertCompletionNotDone(parent);
        this.assertResponseDone(child);
        this.assertCompletionNotDone(child);
        this.assertResponseNotDone(grandchild);
        this.assertCompletionNotDone(grandchild);
        grandchild.success();
        this.assertResponseDone(parent);
        this.assertCompletionDone(parent);
        this.assertResponseDone(child);
        this.assertCompletionDone(child);
        this.assertResponseDone(grandchild);
        this.assertCompletionDone(grandchild);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete, even if one branch of the tree completes.")
    public void multipleBranches() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        EventContext child1 = DefaultEventContext.child((EventContext)parent);
        EventContext child2 = DefaultEventContext.child((EventContext)parent);
        EventContext grandchild1 = DefaultEventContext.child((EventContext)child1);
        EventContext grandchild2 = DefaultEventContext.child((EventContext)child1);
        EventContext grandchild3 = DefaultEventContext.child((EventContext)child2);
        EventContext grandchild4 = DefaultEventContext.child((EventContext)child2);
        grandchild1.success();
        grandchild2.success();
        this.assertCompletionDone(grandchild1);
        this.assertCompletionDone(grandchild2);
        this.assertCompletionNotDone(child1);
        this.assertCompletionNotDone(parent);
        child1.success();
        this.assertCompletionDone(child1);
        this.assertCompletionNotDone(parent);
        grandchild3.success();
        grandchild4.success();
        child2.success();
        this.assertCompletionDone(grandchild3);
        this.assertCompletionDone(grandchild4);
        this.assertCompletionDone(child2);
        this.assertCompletionNotDone(parent);
        parent.success();
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="EventContext response publisher completes with value of result but the completion publisher only completes  once the external publisher completes.")
    public void externalCompletionSuccess() throws Exception {
        MonoProcessor externalCompletion = MonoProcessor.create();
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION, null, (Publisher)externalCompletion);
        Event event = this.testEvent();
        this.assertCompletionNotDone(parent);
        parent.success(event);
        this.awaitAndAssertResponse(parent, event);
        this.assertCompletionNotDone(parent);
        externalCompletion.onComplete();
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="EventContext response publisher completes with error but the completion publisher only completes  once the external publisher completes.")
    public void externalCompletionError() throws Exception {
        MonoProcessor externalCompletion = MonoProcessor.create();
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION, null, (Publisher)externalCompletion);
        RuntimeException exception = new RuntimeException();
        this.assertCompletionNotDone(parent);
        parent.error((Throwable)exception);
        this.assertCompletionNotDone(parent);
        externalCompletion.onComplete();
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete and external completion completes.")
    public void externalCompletionWithChild() throws Exception {
        MonoProcessor externalCompletion = MonoProcessor.create();
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION, null, (Publisher)externalCompletion);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        Event event = this.testEvent();
        child.success(event);
        this.awaitAndAssertResponse(child, event);
        this.assertCompletionDone(child);
        this.assertCompletionNotDone(parent);
        parent.success(event);
        this.awaitAndAssertResponse(parent, event);
        this.assertCompletionNotDone(parent);
        externalCompletion.onComplete();
        this.assertCompletionDone(parent);
    }

    @Test
    @Description(value="When a child event context is de-serialized it is decoupled from parent context but response and completion publisher still complete when a response event is available.")
    public void deserializedChild() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION, null);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        byte[] bytes = muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)child);
        EventContext deserializedChild = (EventContext)muleContext.getObjectSerializer().getExternalProtocol().deserialize(bytes);
        Event event = this.testEvent();
        deserializedChild.success(event);
        this.awaitAndAssertResponse(deserializedChild, event);
        this.assertCompletionDone(deserializedChild);
    }

    @Test
    @Description(value="When a parent event context is de-serialized the parent context no longer waits for completion of child context.")
    public void deserializedParent() throws Exception {
        EventContext parent = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION, null);
        EventContext child = DefaultEventContext.child((EventContext)parent);
        byte[] bytes = muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)parent);
        EventContext deserializedParent = (EventContext)muleContext.getObjectSerializer().getExternalProtocol().deserialize(bytes);
        Event event = this.testEvent();
        deserializedParent.success(event);
        this.awaitAndAssertResponse(deserializedParent, event);
        this.assertCompletionDone(deserializedParent);
    }

    @Test
    @Description(value="Verify that a location produces connector and source data.")
    public void componentData() throws Exception {
        TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().withType(TypedComponentIdentifier.ComponentType.SOURCE).withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"http:listener")).build();
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)location.getComponentIdentifier()).thenReturn((Object)typedComponentIdentifier);
        EventContext context = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)location);
        Assert.assertThat((Object)context.getOriginatingConnectorName(), (Matcher)CoreMatchers.is((Object)"http"));
        Assert.assertThat((Object)context.getOriginatingSourceName(), (Matcher)CoreMatchers.is((Object)"listener"));
    }

    @Test
    @Description(value="Verify that a single component location produces connector and source data.")
    public void componentDataFromSingleComponent() throws Exception {
        EventContext context = DefaultEventContext.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION);
        Assert.assertThat((Object)context.getOriginatingConnectorName(), (Matcher)CoreMatchers.is((Object)"mule"));
        Assert.assertThat((Object)context.getOriginatingSourceName(), (Matcher)CoreMatchers.is((Object)"test"));
    }

    private void assertBeforeResponseDone(EventContext parent) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getBeforeResponsePublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void awaitAndAssertResponse(EventContext parent, Event event) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getResponsePublisher()).block(Duration.ofMillis(500L)), (Matcher)CoreMatchers.equalTo((Object)event));
    }

    private void awaittNullResponse(EventContext child) {
        Assert.assertThat((Object)Mono.from((Publisher)child.getResponsePublisher()).block(Duration.ofMillis(500L)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void assertResponseDone(EventContext parent) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getResponsePublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertResponseNotDone(EventContext parent) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getResponsePublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void awaitCompletion(EventContext parent) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getCompletionPublisher()).block(Duration.ofMillis(500L)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void assertCompletionDone(EventContext parent) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getCompletionPublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertCompletionNotDone(EventContext child1) {
        Assert.assertThat((Object)Mono.from((Publisher)child1.getCompletionPublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)false));
    }
}

