/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultMessageContextTestCase
extends AbstractMuleTestCase {
    private static final String GENERATED_CORRELATION_ID = "generatedCorrelationIdValue";
    private static final String CUSTOM_CORRELATION_ID = "customCorrelationIdValue";
    private static final String SERVER_ID = "serverId";
    @Mock
    private MuleConfiguration muleConfig;
    @Mock
    private MuleContext muleContext;
    @Mock
    private FlowConstruct flow;
    private EventContext executionContext;
    private EventContext executionContextWithCorrelation;

    @Before
    public void before() {
        Mockito.when((Object)this.flow.getUniqueIdString()).thenReturn((Object)GENERATED_CORRELATION_ID);
        Mockito.when((Object)this.flow.getServerId()).thenReturn((Object)SERVER_ID);
        this.executionContext = DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
        this.executionContextWithCorrelation = DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)CUSTOM_CORRELATION_ID);
    }

    @Test
    public void noCorrelationIdInContext() {
        Message message = Message.of((Object)"test");
        Event event = Event.builder((EventContext)this.executionContext).message(message).flow(this.flow).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)GENERATED_CORRELATION_ID));
    }

    @Test
    public void correlationIdInContext() {
        Message message = Message.of((Object)"test");
        Event event = Event.builder((EventContext)this.executionContextWithCorrelation).message(message).flow(this.flow).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)CUSTOM_CORRELATION_ID));
    }

    @Test
    public void overrideCorrelationIdInContext() {
        Message message = Message.of((Object)"test");
        Event event = Event.builder((EventContext)this.executionContextWithCorrelation).message(message).flow(this.flow).groupCorrelation(new GroupCorrelation(null, null)).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)CUSTOM_CORRELATION_ID));
    }

    @Test
    public void overrideCorrelationIdInContextSequence() {
        Message message = Message.of((Object)"test");
        Event event = Event.builder((EventContext)this.executionContextWithCorrelation).message(message).correlationId(CUSTOM_CORRELATION_ID).flow(this.flow).groupCorrelation(new GroupCorrelation(null, Integer.valueOf(6))).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)CUSTOM_CORRELATION_ID));
    }
}

